/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.JsonClassifier;
import java.util.Date;

@SdkInternalApi
public class JsonClassifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> JSONPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JsonPath").build();
    private static final JsonClassifierMarshaller instance = new JsonClassifierMarshaller();

    public static JsonClassifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(JsonClassifier jsonClassifier, ProtocolMarshaller protocolMarshaller) {
        if (jsonClassifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(jsonClassifier.getName(), NAME_BINDING);
            protocolMarshaller.marshall(jsonClassifier.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(jsonClassifier.getLastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall(jsonClassifier.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(jsonClassifier.getJsonPath(), JSONPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

