/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ConnectionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CONNECTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionType").build();
    private static final MarshallingInfo<List> MATCHCRITERIA_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchCriteria").build();
    private static final MarshallingInfo<Map> CONNECTIONPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionProperties").build();
    private static final MarshallingInfo<StructuredPojo> PHYSICALCONNECTIONREQUIREMENTS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhysicalConnectionRequirements").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LASTUPDATEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedBy").build();
    private static final ConnectionMarshaller instance = new ConnectionMarshaller();

    public static ConnectionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Connection connection, ProtocolMarshaller protocolMarshaller) {
        if (connection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(connection.getName(), NAME_BINDING);
            protocolMarshaller.marshall(connection.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(connection.getConnectionType(), CONNECTIONTYPE_BINDING);
            protocolMarshaller.marshall(connection.getMatchCriteria(), MATCHCRITERIA_BINDING);
            protocolMarshaller.marshall(connection.getConnectionProperties(), CONNECTIONPROPERTIES_BINDING);
            protocolMarshaller.marshall(connection.getPhysicalConnectionRequirements(), PHYSICALCONNECTIONREQUIREMENTS_BINDING);
            protocolMarshaller.marshall(connection.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(connection.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall(connection.getLastUpdatedBy(), LASTUPDATEDBY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

