/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.CrawlerState;
import com.amazonaws.services.glue.model.CrawlerTargets;
import com.amazonaws.services.glue.model.LastCrawlInfo;
import com.amazonaws.services.glue.model.Schedule;
import com.amazonaws.services.glue.model.SchemaChangePolicy;
import com.amazonaws.services.glue.model.transform.CrawlerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Crawler
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String role;
    private CrawlerTargets targets;
    private String databaseName;
    private String description;
    private List<String> classifiers;
    private SchemaChangePolicy schemaChangePolicy;
    private String state;
    private String tablePrefix;
    private Schedule schedule;
    private Long crawlElapsedTime;
    private Date creationTime;
    private Date lastUpdated;
    private LastCrawlInfo lastCrawl;
    private Long version;
    private String configuration;
    private String crawlerSecurityConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Crawler withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public Crawler withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setTargets(CrawlerTargets targets) {
        this.targets = targets;
    }

    public CrawlerTargets getTargets() {
        return this.targets;
    }

    public Crawler withTargets(CrawlerTargets targets) {
        this.setTargets(targets);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Crawler withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Crawler withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getClassifiers() {
        return this.classifiers;
    }

    public void setClassifiers(Collection<String> classifiers) {
        if (classifiers == null) {
            this.classifiers = null;
            return;
        }
        this.classifiers = new ArrayList<String>(classifiers);
    }

    public Crawler withClassifiers(String ... classifiers) {
        if (this.classifiers == null) {
            this.setClassifiers(new ArrayList<String>(classifiers.length));
        }
        for (String ele : classifiers) {
            this.classifiers.add(ele);
        }
        return this;
    }

    public Crawler withClassifiers(Collection<String> classifiers) {
        this.setClassifiers(classifiers);
        return this;
    }

    public void setSchemaChangePolicy(SchemaChangePolicy schemaChangePolicy) {
        this.schemaChangePolicy = schemaChangePolicy;
    }

    public SchemaChangePolicy getSchemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public Crawler withSchemaChangePolicy(SchemaChangePolicy schemaChangePolicy) {
        this.setSchemaChangePolicy(schemaChangePolicy);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Crawler withState(String state) {
        this.setState(state);
        return this;
    }

    public Crawler withState(CrawlerState state) {
        this.state = state.toString();
        return this;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public Crawler withTablePrefix(String tablePrefix) {
        this.setTablePrefix(tablePrefix);
        return this;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Crawler withSchedule(Schedule schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setCrawlElapsedTime(Long crawlElapsedTime) {
        this.crawlElapsedTime = crawlElapsedTime;
    }

    public Long getCrawlElapsedTime() {
        return this.crawlElapsedTime;
    }

    public Crawler withCrawlElapsedTime(Long crawlElapsedTime) {
        this.setCrawlElapsedTime(crawlElapsedTime);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Crawler withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public Crawler withLastUpdated(Date lastUpdated) {
        this.setLastUpdated(lastUpdated);
        return this;
    }

    public void setLastCrawl(LastCrawlInfo lastCrawl) {
        this.lastCrawl = lastCrawl;
    }

    public LastCrawlInfo getLastCrawl() {
        return this.lastCrawl;
    }

    public Crawler withLastCrawl(LastCrawlInfo lastCrawl) {
        this.setLastCrawl(lastCrawl);
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public Crawler withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public Crawler withConfiguration(String configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setCrawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
        this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
    }

    public String getCrawlerSecurityConfiguration() {
        return this.crawlerSecurityConfiguration;
    }

    public Crawler withCrawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
        this.setCrawlerSecurityConfiguration(crawlerSecurityConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getClassifiers() != null) {
            sb.append("Classifiers: ").append(this.getClassifiers()).append(",");
        }
        if (this.getSchemaChangePolicy() != null) {
            sb.append("SchemaChangePolicy: ").append(this.getSchemaChangePolicy()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getTablePrefix() != null) {
            sb.append("TablePrefix: ").append(this.getTablePrefix()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getCrawlElapsedTime() != null) {
            sb.append("CrawlElapsedTime: ").append(this.getCrawlElapsedTime()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdated() != null) {
            sb.append("LastUpdated: ").append(this.getLastUpdated()).append(",");
        }
        if (this.getLastCrawl() != null) {
            sb.append("LastCrawl: ").append(this.getLastCrawl()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getCrawlerSecurityConfiguration() != null) {
            sb.append("CrawlerSecurityConfiguration: ").append(this.getCrawlerSecurityConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Crawler)) {
            return false;
        }
        Crawler other = (Crawler)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getClassifiers() == null ^ this.getClassifiers() == null) {
            return false;
        }
        if (other.getClassifiers() != null && !other.getClassifiers().equals(this.getClassifiers())) {
            return false;
        }
        if (other.getSchemaChangePolicy() == null ^ this.getSchemaChangePolicy() == null) {
            return false;
        }
        if (other.getSchemaChangePolicy() != null && !other.getSchemaChangePolicy().equals(this.getSchemaChangePolicy())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTablePrefix() == null ^ this.getTablePrefix() == null) {
            return false;
        }
        if (other.getTablePrefix() != null && !other.getTablePrefix().equals(this.getTablePrefix())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getCrawlElapsedTime() == null ^ this.getCrawlElapsedTime() == null) {
            return false;
        }
        if (other.getCrawlElapsedTime() != null && !other.getCrawlElapsedTime().equals(this.getCrawlElapsedTime())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdated() == null ^ this.getLastUpdated() == null) {
            return false;
        }
        if (other.getLastUpdated() != null && !other.getLastUpdated().equals(this.getLastUpdated())) {
            return false;
        }
        if (other.getLastCrawl() == null ^ this.getLastCrawl() == null) {
            return false;
        }
        if (other.getLastCrawl() != null && !other.getLastCrawl().equals(this.getLastCrawl())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getCrawlerSecurityConfiguration() == null ^ this.getCrawlerSecurityConfiguration() == null) {
            return false;
        }
        return other.getCrawlerSecurityConfiguration() == null || other.getCrawlerSecurityConfiguration().equals(this.getCrawlerSecurityConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClassifiers() == null ? 0 : this.getClassifiers().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaChangePolicy() == null ? 0 : this.getSchemaChangePolicy().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTablePrefix() == null ? 0 : this.getTablePrefix().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlElapsedTime() == null ? 0 : this.getCrawlElapsedTime().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdated() == null ? 0 : this.getLastUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getLastCrawl() == null ? 0 : this.getLastCrawl().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlerSecurityConfiguration() == null ? 0 : this.getCrawlerSecurityConfiguration().hashCode());
        return hashCode;
    }

    public Crawler clone() {
        try {
            return (Crawler)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CrawlerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

