/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.EvaluationResult;
import com.amazonaws.services.fms.model.transform.PolicyComplianceStatusMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyComplianceStatus
implements Serializable,
Cloneable,
StructuredPojo {
    private String policyOwner;
    private String policyId;
    private String policyName;
    private String memberAccount;
    private List<EvaluationResult> evaluationResults;
    private Date lastUpdated;
    private Map<String, String> issueInfoMap;

    public void setPolicyOwner(String policyOwner) {
        this.policyOwner = policyOwner;
    }

    public String getPolicyOwner() {
        return this.policyOwner;
    }

    public PolicyComplianceStatus withPolicyOwner(String policyOwner) {
        this.setPolicyOwner(policyOwner);
        return this;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public PolicyComplianceStatus withPolicyId(String policyId) {
        this.setPolicyId(policyId);
        return this;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public PolicyComplianceStatus withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public void setMemberAccount(String memberAccount) {
        this.memberAccount = memberAccount;
    }

    public String getMemberAccount() {
        return this.memberAccount;
    }

    public PolicyComplianceStatus withMemberAccount(String memberAccount) {
        this.setMemberAccount(memberAccount);
        return this;
    }

    public List<EvaluationResult> getEvaluationResults() {
        return this.evaluationResults;
    }

    public void setEvaluationResults(Collection<EvaluationResult> evaluationResults) {
        if (evaluationResults == null) {
            this.evaluationResults = null;
            return;
        }
        this.evaluationResults = new ArrayList<EvaluationResult>(evaluationResults);
    }

    public PolicyComplianceStatus withEvaluationResults(EvaluationResult ... evaluationResults) {
        if (this.evaluationResults == null) {
            this.setEvaluationResults(new ArrayList<EvaluationResult>(evaluationResults.length));
        }
        for (EvaluationResult ele : evaluationResults) {
            this.evaluationResults.add(ele);
        }
        return this;
    }

    public PolicyComplianceStatus withEvaluationResults(Collection<EvaluationResult> evaluationResults) {
        this.setEvaluationResults(evaluationResults);
        return this;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public PolicyComplianceStatus withLastUpdated(Date lastUpdated) {
        this.setLastUpdated(lastUpdated);
        return this;
    }

    public Map<String, String> getIssueInfoMap() {
        return this.issueInfoMap;
    }

    public void setIssueInfoMap(Map<String, String> issueInfoMap) {
        this.issueInfoMap = issueInfoMap;
    }

    public PolicyComplianceStatus withIssueInfoMap(Map<String, String> issueInfoMap) {
        this.setIssueInfoMap(issueInfoMap);
        return this;
    }

    public PolicyComplianceStatus addIssueInfoMapEntry(String key, String value) {
        if (null == this.issueInfoMap) {
            this.issueInfoMap = new HashMap<String, String>();
        }
        if (this.issueInfoMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.issueInfoMap.put(key, value);
        return this;
    }

    public PolicyComplianceStatus clearIssueInfoMapEntries() {
        this.issueInfoMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyOwner() != null) {
            sb.append("PolicyOwner: ").append(this.getPolicyOwner()).append(",");
        }
        if (this.getPolicyId() != null) {
            sb.append("PolicyId: ").append(this.getPolicyId()).append(",");
        }
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getMemberAccount() != null) {
            sb.append("MemberAccount: ").append(this.getMemberAccount()).append(",");
        }
        if (this.getEvaluationResults() != null) {
            sb.append("EvaluationResults: ").append(this.getEvaluationResults()).append(",");
        }
        if (this.getLastUpdated() != null) {
            sb.append("LastUpdated: ").append(this.getLastUpdated()).append(",");
        }
        if (this.getIssueInfoMap() != null) {
            sb.append("IssueInfoMap: ").append(this.getIssueInfoMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyComplianceStatus)) {
            return false;
        }
        PolicyComplianceStatus other = (PolicyComplianceStatus)obj;
        if (other.getPolicyOwner() == null ^ this.getPolicyOwner() == null) {
            return false;
        }
        if (other.getPolicyOwner() != null && !other.getPolicyOwner().equals(this.getPolicyOwner())) {
            return false;
        }
        if (other.getPolicyId() == null ^ this.getPolicyId() == null) {
            return false;
        }
        if (other.getPolicyId() != null && !other.getPolicyId().equals(this.getPolicyId())) {
            return false;
        }
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getMemberAccount() == null ^ this.getMemberAccount() == null) {
            return false;
        }
        if (other.getMemberAccount() != null && !other.getMemberAccount().equals(this.getMemberAccount())) {
            return false;
        }
        if (other.getEvaluationResults() == null ^ this.getEvaluationResults() == null) {
            return false;
        }
        if (other.getEvaluationResults() != null && !other.getEvaluationResults().equals(this.getEvaluationResults())) {
            return false;
        }
        if (other.getLastUpdated() == null ^ this.getLastUpdated() == null) {
            return false;
        }
        if (other.getLastUpdated() != null && !other.getLastUpdated().equals(this.getLastUpdated())) {
            return false;
        }
        if (other.getIssueInfoMap() == null ^ this.getIssueInfoMap() == null) {
            return false;
        }
        return other.getIssueInfoMap() == null || other.getIssueInfoMap().equals(this.getIssueInfoMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyOwner() == null ? 0 : this.getPolicyOwner().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyId() == null ? 0 : this.getPolicyId().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getMemberAccount() == null ? 0 : this.getMemberAccount().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationResults() == null ? 0 : this.getEvaluationResults().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdated() == null ? 0 : this.getLastUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getIssueInfoMap() == null ? 0 : this.getIssueInfoMap().hashCode());
        return hashCode;
    }

    public PolicyComplianceStatus clone() {
        try {
            return (PolicyComplianceStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyComplianceStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

