/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.PolicyComplianceStatusType;
import com.amazonaws.services.fms.model.transform.EvaluationResultMarshaller;
import java.io.Serializable;

public class EvaluationResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String complianceStatus;
    private Long violatorCount;
    private Boolean evaluationLimitExceeded;

    public void setComplianceStatus(String complianceStatus) {
        this.complianceStatus = complianceStatus;
    }

    public String getComplianceStatus() {
        return this.complianceStatus;
    }

    public EvaluationResult withComplianceStatus(String complianceStatus) {
        this.setComplianceStatus(complianceStatus);
        return this;
    }

    public EvaluationResult withComplianceStatus(PolicyComplianceStatusType complianceStatus) {
        this.complianceStatus = complianceStatus.toString();
        return this;
    }

    public void setViolatorCount(Long violatorCount) {
        this.violatorCount = violatorCount;
    }

    public Long getViolatorCount() {
        return this.violatorCount;
    }

    public EvaluationResult withViolatorCount(Long violatorCount) {
        this.setViolatorCount(violatorCount);
        return this;
    }

    public void setEvaluationLimitExceeded(Boolean evaluationLimitExceeded) {
        this.evaluationLimitExceeded = evaluationLimitExceeded;
    }

    public Boolean getEvaluationLimitExceeded() {
        return this.evaluationLimitExceeded;
    }

    public EvaluationResult withEvaluationLimitExceeded(Boolean evaluationLimitExceeded) {
        this.setEvaluationLimitExceeded(evaluationLimitExceeded);
        return this;
    }

    public Boolean isEvaluationLimitExceeded() {
        return this.evaluationLimitExceeded;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComplianceStatus() != null) {
            sb.append("ComplianceStatus: ").append(this.getComplianceStatus()).append(",");
        }
        if (this.getViolatorCount() != null) {
            sb.append("ViolatorCount: ").append(this.getViolatorCount()).append(",");
        }
        if (this.getEvaluationLimitExceeded() != null) {
            sb.append("EvaluationLimitExceeded: ").append(this.getEvaluationLimitExceeded());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        if (other.getComplianceStatus() == null ^ this.getComplianceStatus() == null) {
            return false;
        }
        if (other.getComplianceStatus() != null && !other.getComplianceStatus().equals(this.getComplianceStatus())) {
            return false;
        }
        if (other.getViolatorCount() == null ^ this.getViolatorCount() == null) {
            return false;
        }
        if (other.getViolatorCount() != null && !other.getViolatorCount().equals(this.getViolatorCount())) {
            return false;
        }
        if (other.getEvaluationLimitExceeded() == null ^ this.getEvaluationLimitExceeded() == null) {
            return false;
        }
        return other.getEvaluationLimitExceeded() == null || other.getEvaluationLimitExceeded().equals(this.getEvaluationLimitExceeded());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComplianceStatus() == null ? 0 : this.getComplianceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getViolatorCount() == null ? 0 : this.getViolatorCount().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationLimitExceeded() == null ? 0 : this.getEvaluationLimitExceeded().hashCode());
        return hashCode;
    }

    public EvaluationResult clone() {
        try {
            return (EvaluationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

