/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.CreateRule;
import com.amazonaws.services.dlm.model.RetainRule;
import com.amazonaws.services.dlm.model.Tag;
import com.amazonaws.services.dlm.model.transform.ScheduleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Schedule
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<Tag> tagsToAdd;
    private CreateRule createRule;
    private RetainRule retainRule;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Schedule withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Tag> getTagsToAdd() {
        return this.tagsToAdd;
    }

    public void setTagsToAdd(Collection<Tag> tagsToAdd) {
        if (tagsToAdd == null) {
            this.tagsToAdd = null;
            return;
        }
        this.tagsToAdd = new ArrayList<Tag>(tagsToAdd);
    }

    public Schedule withTagsToAdd(Tag ... tagsToAdd) {
        if (this.tagsToAdd == null) {
            this.setTagsToAdd(new ArrayList<Tag>(tagsToAdd.length));
        }
        for (Tag ele : tagsToAdd) {
            this.tagsToAdd.add(ele);
        }
        return this;
    }

    public Schedule withTagsToAdd(Collection<Tag> tagsToAdd) {
        this.setTagsToAdd(tagsToAdd);
        return this;
    }

    public void setCreateRule(CreateRule createRule) {
        this.createRule = createRule;
    }

    public CreateRule getCreateRule() {
        return this.createRule;
    }

    public Schedule withCreateRule(CreateRule createRule) {
        this.setCreateRule(createRule);
        return this;
    }

    public void setRetainRule(RetainRule retainRule) {
        this.retainRule = retainRule;
    }

    public RetainRule getRetainRule() {
        return this.retainRule;
    }

    public Schedule withRetainRule(RetainRule retainRule) {
        this.setRetainRule(retainRule);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTagsToAdd() != null) {
            sb.append("TagsToAdd: ").append(this.getTagsToAdd()).append(",");
        }
        if (this.getCreateRule() != null) {
            sb.append("CreateRule: ").append(this.getCreateRule()).append(",");
        }
        if (this.getRetainRule() != null) {
            sb.append("RetainRule: ").append(this.getRetainRule());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTagsToAdd() == null ^ this.getTagsToAdd() == null) {
            return false;
        }
        if (other.getTagsToAdd() != null && !other.getTagsToAdd().equals(this.getTagsToAdd())) {
            return false;
        }
        if (other.getCreateRule() == null ^ this.getCreateRule() == null) {
            return false;
        }
        if (other.getCreateRule() != null && !other.getCreateRule().equals(this.getCreateRule())) {
            return false;
        }
        if (other.getRetainRule() == null ^ this.getRetainRule() == null) {
            return false;
        }
        return other.getRetainRule() == null || other.getRetainRule().equals(this.getRetainRule());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTagsToAdd() == null ? 0 : this.getTagsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getCreateRule() == null ? 0 : this.getCreateRule().hashCode());
        hashCode = 31 * hashCode + (this.getRetainRule() == null ? 0 : this.getRetainRule().hashCode());
        return hashCode;
    }

    public Schedule clone() {
        try {
            return (Schedule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

