/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.ResourceTypeValues;
import com.amazonaws.services.dlm.model.Schedule;
import com.amazonaws.services.dlm.model.Tag;
import com.amazonaws.services.dlm.model.transform.PolicyDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> resourceTypes;
    private List<Tag> targetTags;
    private List<Schedule> schedules;

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public PolicyDetails withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public PolicyDetails withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public PolicyDetails withResourceTypes(ResourceTypeValues ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ResourceTypeValues value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public List<Tag> getTargetTags() {
        return this.targetTags;
    }

    public void setTargetTags(Collection<Tag> targetTags) {
        if (targetTags == null) {
            this.targetTags = null;
            return;
        }
        this.targetTags = new ArrayList<Tag>(targetTags);
    }

    public PolicyDetails withTargetTags(Tag ... targetTags) {
        if (this.targetTags == null) {
            this.setTargetTags(new ArrayList<Tag>(targetTags.length));
        }
        for (Tag ele : targetTags) {
            this.targetTags.add(ele);
        }
        return this;
    }

    public PolicyDetails withTargetTags(Collection<Tag> targetTags) {
        this.setTargetTags(targetTags);
        return this;
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<Schedule> schedules) {
        if (schedules == null) {
            this.schedules = null;
            return;
        }
        this.schedules = new ArrayList<Schedule>(schedules);
    }

    public PolicyDetails withSchedules(Schedule ... schedules) {
        if (this.schedules == null) {
            this.setSchedules(new ArrayList<Schedule>(schedules.length));
        }
        for (Schedule ele : schedules) {
            this.schedules.add(ele);
        }
        return this;
    }

    public PolicyDetails withSchedules(Collection<Schedule> schedules) {
        this.setSchedules(schedules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getTargetTags() != null) {
            sb.append("TargetTags: ").append(this.getTargetTags()).append(",");
        }
        if (this.getSchedules() != null) {
            sb.append("Schedules: ").append(this.getSchedules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDetails)) {
            return false;
        }
        PolicyDetails other = (PolicyDetails)obj;
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getTargetTags() == null ^ this.getTargetTags() == null) {
            return false;
        }
        if (other.getTargetTags() != null && !other.getTargetTags().equals(this.getTargetTags())) {
            return false;
        }
        if (other.getSchedules() == null ^ this.getSchedules() == null) {
            return false;
        }
        return other.getSchedules() == null || other.getSchedules().equals(this.getSchedules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTags() == null ? 0 : this.getTargetTags().hashCode());
        hashCode = 31 * hashCode + (this.getSchedules() == null ? 0 : this.getSchedules().hashCode());
        return hashCode;
    }

    public PolicyDetails clone() {
        try {
            return (PolicyDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

