/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.ServiceSpecification;

@SdkInternalApi
public class ServiceSpecificationMarshaller {
    private static final MarshallingInfo<StructuredPojo> EC2SPECIFICATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2Specification").build();
    private static final ServiceSpecificationMarshaller instance = new ServiceSpecificationMarshaller();

    public static ServiceSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ServiceSpecification serviceSpecification, ProtocolMarshaller protocolMarshaller) {
        if (serviceSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(serviceSpecification.getEC2Specification(), EC2SPECIFICATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

