/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.ReservationAggregates;

@SdkInternalApi
public class ReservationAggregatesMarshaller {
    private static final MarshallingInfo<String> UTILIZATIONPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UtilizationPercentage").build();
    private static final MarshallingInfo<String> PURCHASEDHOURS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PurchasedHours").build();
    private static final MarshallingInfo<String> TOTALACTUALHOURS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalActualHours").build();
    private static final MarshallingInfo<String> UNUSEDHOURS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnusedHours").build();
    private static final MarshallingInfo<String> ONDEMANDCOSTOFRIHOURSUSED_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OnDemandCostOfRIHoursUsed").build();
    private static final MarshallingInfo<String> NETRISAVINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetRISavings").build();
    private static final MarshallingInfo<String> TOTALPOTENTIALRISAVINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalPotentialRISavings").build();
    private static final MarshallingInfo<String> AMORTIZEDUPFRONTFEE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmortizedUpfrontFee").build();
    private static final MarshallingInfo<String> AMORTIZEDRECURRINGFEE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmortizedRecurringFee").build();
    private static final MarshallingInfo<String> TOTALAMORTIZEDFEE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalAmortizedFee").build();
    private static final ReservationAggregatesMarshaller instance = new ReservationAggregatesMarshaller();

    public static ReservationAggregatesMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReservationAggregates reservationAggregates, ProtocolMarshaller protocolMarshaller) {
        if (reservationAggregates == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(reservationAggregates.getUtilizationPercentage(), UTILIZATIONPERCENTAGE_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getPurchasedHours(), PURCHASEDHOURS_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getTotalActualHours(), TOTALACTUALHOURS_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getUnusedHours(), UNUSEDHOURS_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getOnDemandCostOfRIHoursUsed(), ONDEMANDCOSTOFRIHOURSUSED_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getNetRISavings(), NETRISAVINGS_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getTotalPotentialRISavings(), TOTALPOTENTIALRISAVINGS_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getAmortizedUpfrontFee(), AMORTIZEDUPFRONTFEE_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getAmortizedRecurringFee(), AMORTIZEDRECURRINGFEE_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getTotalAmortizedFee(), TOTALAMORTIZEDFEE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

