/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.Filters;
import com.amazonaws.services.connect.model.Grouping;
import com.amazonaws.services.connect.model.HistoricalMetric;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetMetricDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private Date startTime;
    private Date endTime;
    private Filters filters;
    private List<String> groupings;
    private List<HistoricalMetric> historicalMetrics;
    private String nextToken;
    private Integer maxResults;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public GetMetricDataRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GetMetricDataRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GetMetricDataRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public GetMetricDataRequest withFilters(Filters filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getGroupings() {
        return this.groupings;
    }

    public void setGroupings(Collection<String> groupings) {
        if (groupings == null) {
            this.groupings = null;
            return;
        }
        this.groupings = new ArrayList<String>(groupings);
    }

    public GetMetricDataRequest withGroupings(String ... groupings) {
        if (this.groupings == null) {
            this.setGroupings(new ArrayList<String>(groupings.length));
        }
        for (String ele : groupings) {
            this.groupings.add(ele);
        }
        return this;
    }

    public GetMetricDataRequest withGroupings(Collection<String> groupings) {
        this.setGroupings(groupings);
        return this;
    }

    public GetMetricDataRequest withGroupings(Grouping ... groupings) {
        ArrayList<String> groupingsCopy = new ArrayList<String>(groupings.length);
        for (Grouping value : groupings) {
            groupingsCopy.add(value.toString());
        }
        if (this.getGroupings() == null) {
            this.setGroupings(groupingsCopy);
        } else {
            this.getGroupings().addAll(groupingsCopy);
        }
        return this;
    }

    public List<HistoricalMetric> getHistoricalMetrics() {
        return this.historicalMetrics;
    }

    public void setHistoricalMetrics(Collection<HistoricalMetric> historicalMetrics) {
        if (historicalMetrics == null) {
            this.historicalMetrics = null;
            return;
        }
        this.historicalMetrics = new ArrayList<HistoricalMetric>(historicalMetrics);
    }

    public GetMetricDataRequest withHistoricalMetrics(HistoricalMetric ... historicalMetrics) {
        if (this.historicalMetrics == null) {
            this.setHistoricalMetrics(new ArrayList<HistoricalMetric>(historicalMetrics.length));
        }
        for (HistoricalMetric ele : historicalMetrics) {
            this.historicalMetrics.add(ele);
        }
        return this;
    }

    public GetMetricDataRequest withHistoricalMetrics(Collection<HistoricalMetric> historicalMetrics) {
        this.setHistoricalMetrics(historicalMetrics);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetMetricDataRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetMetricDataRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getGroupings() != null) {
            sb.append("Groupings: ").append(this.getGroupings()).append(",");
        }
        if (this.getHistoricalMetrics() != null) {
            sb.append("HistoricalMetrics: ").append(this.getHistoricalMetrics()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataRequest)) {
            return false;
        }
        GetMetricDataRequest other = (GetMetricDataRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getGroupings() == null ^ this.getGroupings() == null) {
            return false;
        }
        if (other.getGroupings() != null && !other.getGroupings().equals(this.getGroupings())) {
            return false;
        }
        if (other.getHistoricalMetrics() == null ^ this.getHistoricalMetrics() == null) {
            return false;
        }
        if (other.getHistoricalMetrics() != null && !other.getHistoricalMetrics().equals(this.getHistoricalMetrics())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getGroupings() == null ? 0 : this.getGroupings().hashCode());
        hashCode = 31 * hashCode + (this.getHistoricalMetrics() == null ? 0 : this.getHistoricalMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public GetMetricDataRequest clone() {
        return (GetMetricDataRequest)super.clone();
    }
}

