/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.SyntaxToken;

@SdkInternalApi
public class SyntaxTokenMarshaller {
    private static final MarshallingInfo<Integer> TOKENID_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenId").build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").build();
    private static final MarshallingInfo<Integer> BEGINOFFSET_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginOffset").build();
    private static final MarshallingInfo<Integer> ENDOFFSET_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndOffset").build();
    private static final MarshallingInfo<StructuredPojo> PARTOFSPEECH_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartOfSpeech").build();
    private static final SyntaxTokenMarshaller instance = new SyntaxTokenMarshaller();

    public static SyntaxTokenMarshaller getInstance() {
        return instance;
    }

    public void marshall(SyntaxToken syntaxToken, ProtocolMarshaller protocolMarshaller) {
        if (syntaxToken == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(syntaxToken.getTokenId(), TOKENID_BINDING);
            protocolMarshaller.marshall(syntaxToken.getText(), TEXT_BINDING);
            protocolMarshaller.marshall(syntaxToken.getBeginOffset(), BEGINOFFSET_BINDING);
            protocolMarshaller.marshall(syntaxToken.getEndOffset(), ENDOFFSET_BINDING);
            protocolMarshaller.marshall(syntaxToken.getPartOfSpeech(), PARTOFSPEECH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

