/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.comprehend.AmazonComprehendAsync;
import com.amazonaws.services.comprehend.AmazonComprehendAsyncClientBuilder;
import com.amazonaws.services.comprehend.AmazonComprehendClient;
import com.amazonaws.services.comprehend.model.BatchDetectDominantLanguageRequest;
import com.amazonaws.services.comprehend.model.BatchDetectDominantLanguageResult;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentRequest;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import com.amazonaws.services.comprehend.model.BatchDetectSyntaxRequest;
import com.amazonaws.services.comprehend.model.BatchDetectSyntaxResult;
import com.amazonaws.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeDominantLanguageDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeEntitiesDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeKeyPhrasesDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeSentimentDetectionJobResult;
import com.amazonaws.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeTopicsDetectionJobResult;
import com.amazonaws.services.comprehend.model.DetectDominantLanguageRequest;
import com.amazonaws.services.comprehend.model.DetectDominantLanguageResult;
import com.amazonaws.services.comprehend.model.DetectEntitiesRequest;
import com.amazonaws.services.comprehend.model.DetectEntitiesResult;
import com.amazonaws.services.comprehend.model.DetectKeyPhrasesRequest;
import com.amazonaws.services.comprehend.model.DetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.DetectSentimentRequest;
import com.amazonaws.services.comprehend.model.DetectSentimentResult;
import com.amazonaws.services.comprehend.model.DetectSyntaxRequest;
import com.amazonaws.services.comprehend.model.DetectSyntaxResult;
import com.amazonaws.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListDominantLanguageDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListEntitiesDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListKeyPhrasesDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListSentimentDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListSentimentDetectionJobsResult;
import com.amazonaws.services.comprehend.model.ListTopicsDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListTopicsDetectionJobsResult;
import com.amazonaws.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartDominantLanguageDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartEntitiesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartEntitiesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartKeyPhrasesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartSentimentDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartSentimentDetectionJobResult;
import com.amazonaws.services.comprehend.model.StartTopicsDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartTopicsDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopDominantLanguageDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopEntitiesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopEntitiesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopKeyPhrasesDetectionJobResult;
import com.amazonaws.services.comprehend.model.StopSentimentDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StopSentimentDetectionJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonComprehendAsyncClient
extends AmazonComprehendClient
implements AmazonComprehendAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonComprehendAsyncClientBuilder asyncBuilder() {
        return AmazonComprehendAsyncClientBuilder.standard();
    }

    AmazonComprehendAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchDetectDominantLanguageResult> batchDetectDominantLanguageAsync(BatchDetectDominantLanguageRequest request) {
        return this.batchDetectDominantLanguageAsync(request, null);
    }

    @Override
    public Future<BatchDetectDominantLanguageResult> batchDetectDominantLanguageAsync(BatchDetectDominantLanguageRequest request, final AsyncHandler<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResult> asyncHandler) {
        final BatchDetectDominantLanguageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectDominantLanguageResult>(){

            @Override
            public BatchDetectDominantLanguageResult call() throws Exception {
                BatchDetectDominantLanguageResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectDominantLanguage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDetectEntitiesResult> batchDetectEntitiesAsync(BatchDetectEntitiesRequest request) {
        return this.batchDetectEntitiesAsync(request, null);
    }

    @Override
    public Future<BatchDetectEntitiesResult> batchDetectEntitiesAsync(BatchDetectEntitiesRequest request, final AsyncHandler<BatchDetectEntitiesRequest, BatchDetectEntitiesResult> asyncHandler) {
        final BatchDetectEntitiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectEntitiesResult>(){

            @Override
            public BatchDetectEntitiesResult call() throws Exception {
                BatchDetectEntitiesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDetectKeyPhrasesResult> batchDetectKeyPhrasesAsync(BatchDetectKeyPhrasesRequest request) {
        return this.batchDetectKeyPhrasesAsync(request, null);
    }

    @Override
    public Future<BatchDetectKeyPhrasesResult> batchDetectKeyPhrasesAsync(BatchDetectKeyPhrasesRequest request, final AsyncHandler<BatchDetectKeyPhrasesRequest, BatchDetectKeyPhrasesResult> asyncHandler) {
        final BatchDetectKeyPhrasesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectKeyPhrasesResult>(){

            @Override
            public BatchDetectKeyPhrasesResult call() throws Exception {
                BatchDetectKeyPhrasesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectKeyPhrases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDetectSentimentResult> batchDetectSentimentAsync(BatchDetectSentimentRequest request) {
        return this.batchDetectSentimentAsync(request, null);
    }

    @Override
    public Future<BatchDetectSentimentResult> batchDetectSentimentAsync(BatchDetectSentimentRequest request, final AsyncHandler<BatchDetectSentimentRequest, BatchDetectSentimentResult> asyncHandler) {
        final BatchDetectSentimentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectSentimentResult>(){

            @Override
            public BatchDetectSentimentResult call() throws Exception {
                BatchDetectSentimentResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectSentiment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDetectSyntaxResult> batchDetectSyntaxAsync(BatchDetectSyntaxRequest request) {
        return this.batchDetectSyntaxAsync(request, null);
    }

    @Override
    public Future<BatchDetectSyntaxResult> batchDetectSyntaxAsync(BatchDetectSyntaxRequest request, final AsyncHandler<BatchDetectSyntaxRequest, BatchDetectSyntaxResult> asyncHandler) {
        final BatchDetectSyntaxRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectSyntaxResult>(){

            @Override
            public BatchDetectSyntaxResult call() throws Exception {
                BatchDetectSyntaxResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectSyntax(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDominantLanguageDetectionJobResult> describeDominantLanguageDetectionJobAsync(DescribeDominantLanguageDetectionJobRequest request) {
        return this.describeDominantLanguageDetectionJobAsync(request, null);
    }

    @Override
    public Future<DescribeDominantLanguageDetectionJobResult> describeDominantLanguageDetectionJobAsync(DescribeDominantLanguageDetectionJobRequest request, final AsyncHandler<DescribeDominantLanguageDetectionJobRequest, DescribeDominantLanguageDetectionJobResult> asyncHandler) {
        final DescribeDominantLanguageDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDominantLanguageDetectionJobResult>(){

            @Override
            public DescribeDominantLanguageDetectionJobResult call() throws Exception {
                DescribeDominantLanguageDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDescribeDominantLanguageDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEntitiesDetectionJobResult> describeEntitiesDetectionJobAsync(DescribeEntitiesDetectionJobRequest request) {
        return this.describeEntitiesDetectionJobAsync(request, null);
    }

    @Override
    public Future<DescribeEntitiesDetectionJobResult> describeEntitiesDetectionJobAsync(DescribeEntitiesDetectionJobRequest request, final AsyncHandler<DescribeEntitiesDetectionJobRequest, DescribeEntitiesDetectionJobResult> asyncHandler) {
        final DescribeEntitiesDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEntitiesDetectionJobResult>(){

            @Override
            public DescribeEntitiesDetectionJobResult call() throws Exception {
                DescribeEntitiesDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDescribeEntitiesDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeKeyPhrasesDetectionJobResult> describeKeyPhrasesDetectionJobAsync(DescribeKeyPhrasesDetectionJobRequest request) {
        return this.describeKeyPhrasesDetectionJobAsync(request, null);
    }

    @Override
    public Future<DescribeKeyPhrasesDetectionJobResult> describeKeyPhrasesDetectionJobAsync(DescribeKeyPhrasesDetectionJobRequest request, final AsyncHandler<DescribeKeyPhrasesDetectionJobRequest, DescribeKeyPhrasesDetectionJobResult> asyncHandler) {
        final DescribeKeyPhrasesDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeKeyPhrasesDetectionJobResult>(){

            @Override
            public DescribeKeyPhrasesDetectionJobResult call() throws Exception {
                DescribeKeyPhrasesDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDescribeKeyPhrasesDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSentimentDetectionJobResult> describeSentimentDetectionJobAsync(DescribeSentimentDetectionJobRequest request) {
        return this.describeSentimentDetectionJobAsync(request, null);
    }

    @Override
    public Future<DescribeSentimentDetectionJobResult> describeSentimentDetectionJobAsync(DescribeSentimentDetectionJobRequest request, final AsyncHandler<DescribeSentimentDetectionJobRequest, DescribeSentimentDetectionJobResult> asyncHandler) {
        final DescribeSentimentDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSentimentDetectionJobResult>(){

            @Override
            public DescribeSentimentDetectionJobResult call() throws Exception {
                DescribeSentimentDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDescribeSentimentDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTopicsDetectionJobResult> describeTopicsDetectionJobAsync(DescribeTopicsDetectionJobRequest request) {
        return this.describeTopicsDetectionJobAsync(request, null);
    }

    @Override
    public Future<DescribeTopicsDetectionJobResult> describeTopicsDetectionJobAsync(DescribeTopicsDetectionJobRequest request, final AsyncHandler<DescribeTopicsDetectionJobRequest, DescribeTopicsDetectionJobResult> asyncHandler) {
        final DescribeTopicsDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTopicsDetectionJobResult>(){

            @Override
            public DescribeTopicsDetectionJobResult call() throws Exception {
                DescribeTopicsDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDescribeTopicsDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectDominantLanguageResult> detectDominantLanguageAsync(DetectDominantLanguageRequest request) {
        return this.detectDominantLanguageAsync(request, null);
    }

    @Override
    public Future<DetectDominantLanguageResult> detectDominantLanguageAsync(DetectDominantLanguageRequest request, final AsyncHandler<DetectDominantLanguageRequest, DetectDominantLanguageResult> asyncHandler) {
        final DetectDominantLanguageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectDominantLanguageResult>(){

            @Override
            public DetectDominantLanguageResult call() throws Exception {
                DetectDominantLanguageResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectDominantLanguage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request) {
        return this.detectEntitiesAsync(request, null);
    }

    @Override
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request, final AsyncHandler<DetectEntitiesRequest, DetectEntitiesResult> asyncHandler) {
        final DetectEntitiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectEntitiesResult>(){

            @Override
            public DetectEntitiesResult call() throws Exception {
                DetectEntitiesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectKeyPhrasesResult> detectKeyPhrasesAsync(DetectKeyPhrasesRequest request) {
        return this.detectKeyPhrasesAsync(request, null);
    }

    @Override
    public Future<DetectKeyPhrasesResult> detectKeyPhrasesAsync(DetectKeyPhrasesRequest request, final AsyncHandler<DetectKeyPhrasesRequest, DetectKeyPhrasesResult> asyncHandler) {
        final DetectKeyPhrasesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectKeyPhrasesResult>(){

            @Override
            public DetectKeyPhrasesResult call() throws Exception {
                DetectKeyPhrasesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectKeyPhrases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectSentimentResult> detectSentimentAsync(DetectSentimentRequest request) {
        return this.detectSentimentAsync(request, null);
    }

    @Override
    public Future<DetectSentimentResult> detectSentimentAsync(DetectSentimentRequest request, final AsyncHandler<DetectSentimentRequest, DetectSentimentResult> asyncHandler) {
        final DetectSentimentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectSentimentResult>(){

            @Override
            public DetectSentimentResult call() throws Exception {
                DetectSentimentResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectSentiment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectSyntaxResult> detectSyntaxAsync(DetectSyntaxRequest request) {
        return this.detectSyntaxAsync(request, null);
    }

    @Override
    public Future<DetectSyntaxResult> detectSyntaxAsync(DetectSyntaxRequest request, final AsyncHandler<DetectSyntaxRequest, DetectSyntaxResult> asyncHandler) {
        final DetectSyntaxRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectSyntaxResult>(){

            @Override
            public DetectSyntaxResult call() throws Exception {
                DetectSyntaxResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectSyntax(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDominantLanguageDetectionJobsResult> listDominantLanguageDetectionJobsAsync(ListDominantLanguageDetectionJobsRequest request) {
        return this.listDominantLanguageDetectionJobsAsync(request, null);
    }

    @Override
    public Future<ListDominantLanguageDetectionJobsResult> listDominantLanguageDetectionJobsAsync(ListDominantLanguageDetectionJobsRequest request, final AsyncHandler<ListDominantLanguageDetectionJobsRequest, ListDominantLanguageDetectionJobsResult> asyncHandler) {
        final ListDominantLanguageDetectionJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDominantLanguageDetectionJobsResult>(){

            @Override
            public ListDominantLanguageDetectionJobsResult call() throws Exception {
                ListDominantLanguageDetectionJobsResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeListDominantLanguageDetectionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEntitiesDetectionJobsResult> listEntitiesDetectionJobsAsync(ListEntitiesDetectionJobsRequest request) {
        return this.listEntitiesDetectionJobsAsync(request, null);
    }

    @Override
    public Future<ListEntitiesDetectionJobsResult> listEntitiesDetectionJobsAsync(ListEntitiesDetectionJobsRequest request, final AsyncHandler<ListEntitiesDetectionJobsRequest, ListEntitiesDetectionJobsResult> asyncHandler) {
        final ListEntitiesDetectionJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEntitiesDetectionJobsResult>(){

            @Override
            public ListEntitiesDetectionJobsResult call() throws Exception {
                ListEntitiesDetectionJobsResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeListEntitiesDetectionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKeyPhrasesDetectionJobsResult> listKeyPhrasesDetectionJobsAsync(ListKeyPhrasesDetectionJobsRequest request) {
        return this.listKeyPhrasesDetectionJobsAsync(request, null);
    }

    @Override
    public Future<ListKeyPhrasesDetectionJobsResult> listKeyPhrasesDetectionJobsAsync(ListKeyPhrasesDetectionJobsRequest request, final AsyncHandler<ListKeyPhrasesDetectionJobsRequest, ListKeyPhrasesDetectionJobsResult> asyncHandler) {
        final ListKeyPhrasesDetectionJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListKeyPhrasesDetectionJobsResult>(){

            @Override
            public ListKeyPhrasesDetectionJobsResult call() throws Exception {
                ListKeyPhrasesDetectionJobsResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeListKeyPhrasesDetectionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSentimentDetectionJobsResult> listSentimentDetectionJobsAsync(ListSentimentDetectionJobsRequest request) {
        return this.listSentimentDetectionJobsAsync(request, null);
    }

    @Override
    public Future<ListSentimentDetectionJobsResult> listSentimentDetectionJobsAsync(ListSentimentDetectionJobsRequest request, final AsyncHandler<ListSentimentDetectionJobsRequest, ListSentimentDetectionJobsResult> asyncHandler) {
        final ListSentimentDetectionJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSentimentDetectionJobsResult>(){

            @Override
            public ListSentimentDetectionJobsResult call() throws Exception {
                ListSentimentDetectionJobsResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeListSentimentDetectionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicsDetectionJobsResult> listTopicsDetectionJobsAsync(ListTopicsDetectionJobsRequest request) {
        return this.listTopicsDetectionJobsAsync(request, null);
    }

    @Override
    public Future<ListTopicsDetectionJobsResult> listTopicsDetectionJobsAsync(ListTopicsDetectionJobsRequest request, final AsyncHandler<ListTopicsDetectionJobsRequest, ListTopicsDetectionJobsResult> asyncHandler) {
        final ListTopicsDetectionJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTopicsDetectionJobsResult>(){

            @Override
            public ListTopicsDetectionJobsResult call() throws Exception {
                ListTopicsDetectionJobsResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeListTopicsDetectionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDominantLanguageDetectionJobResult> startDominantLanguageDetectionJobAsync(StartDominantLanguageDetectionJobRequest request) {
        return this.startDominantLanguageDetectionJobAsync(request, null);
    }

    @Override
    public Future<StartDominantLanguageDetectionJobResult> startDominantLanguageDetectionJobAsync(StartDominantLanguageDetectionJobRequest request, final AsyncHandler<StartDominantLanguageDetectionJobRequest, StartDominantLanguageDetectionJobResult> asyncHandler) {
        final StartDominantLanguageDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDominantLanguageDetectionJobResult>(){

            @Override
            public StartDominantLanguageDetectionJobResult call() throws Exception {
                StartDominantLanguageDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStartDominantLanguageDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartEntitiesDetectionJobResult> startEntitiesDetectionJobAsync(StartEntitiesDetectionJobRequest request) {
        return this.startEntitiesDetectionJobAsync(request, null);
    }

    @Override
    public Future<StartEntitiesDetectionJobResult> startEntitiesDetectionJobAsync(StartEntitiesDetectionJobRequest request, final AsyncHandler<StartEntitiesDetectionJobRequest, StartEntitiesDetectionJobResult> asyncHandler) {
        final StartEntitiesDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartEntitiesDetectionJobResult>(){

            @Override
            public StartEntitiesDetectionJobResult call() throws Exception {
                StartEntitiesDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStartEntitiesDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartKeyPhrasesDetectionJobResult> startKeyPhrasesDetectionJobAsync(StartKeyPhrasesDetectionJobRequest request) {
        return this.startKeyPhrasesDetectionJobAsync(request, null);
    }

    @Override
    public Future<StartKeyPhrasesDetectionJobResult> startKeyPhrasesDetectionJobAsync(StartKeyPhrasesDetectionJobRequest request, final AsyncHandler<StartKeyPhrasesDetectionJobRequest, StartKeyPhrasesDetectionJobResult> asyncHandler) {
        final StartKeyPhrasesDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartKeyPhrasesDetectionJobResult>(){

            @Override
            public StartKeyPhrasesDetectionJobResult call() throws Exception {
                StartKeyPhrasesDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStartKeyPhrasesDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSentimentDetectionJobResult> startSentimentDetectionJobAsync(StartSentimentDetectionJobRequest request) {
        return this.startSentimentDetectionJobAsync(request, null);
    }

    @Override
    public Future<StartSentimentDetectionJobResult> startSentimentDetectionJobAsync(StartSentimentDetectionJobRequest request, final AsyncHandler<StartSentimentDetectionJobRequest, StartSentimentDetectionJobResult> asyncHandler) {
        final StartSentimentDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSentimentDetectionJobResult>(){

            @Override
            public StartSentimentDetectionJobResult call() throws Exception {
                StartSentimentDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStartSentimentDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTopicsDetectionJobResult> startTopicsDetectionJobAsync(StartTopicsDetectionJobRequest request) {
        return this.startTopicsDetectionJobAsync(request, null);
    }

    @Override
    public Future<StartTopicsDetectionJobResult> startTopicsDetectionJobAsync(StartTopicsDetectionJobRequest request, final AsyncHandler<StartTopicsDetectionJobRequest, StartTopicsDetectionJobResult> asyncHandler) {
        final StartTopicsDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTopicsDetectionJobResult>(){

            @Override
            public StartTopicsDetectionJobResult call() throws Exception {
                StartTopicsDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStartTopicsDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopDominantLanguageDetectionJobResult> stopDominantLanguageDetectionJobAsync(StopDominantLanguageDetectionJobRequest request) {
        return this.stopDominantLanguageDetectionJobAsync(request, null);
    }

    @Override
    public Future<StopDominantLanguageDetectionJobResult> stopDominantLanguageDetectionJobAsync(StopDominantLanguageDetectionJobRequest request, final AsyncHandler<StopDominantLanguageDetectionJobRequest, StopDominantLanguageDetectionJobResult> asyncHandler) {
        final StopDominantLanguageDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopDominantLanguageDetectionJobResult>(){

            @Override
            public StopDominantLanguageDetectionJobResult call() throws Exception {
                StopDominantLanguageDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStopDominantLanguageDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopEntitiesDetectionJobResult> stopEntitiesDetectionJobAsync(StopEntitiesDetectionJobRequest request) {
        return this.stopEntitiesDetectionJobAsync(request, null);
    }

    @Override
    public Future<StopEntitiesDetectionJobResult> stopEntitiesDetectionJobAsync(StopEntitiesDetectionJobRequest request, final AsyncHandler<StopEntitiesDetectionJobRequest, StopEntitiesDetectionJobResult> asyncHandler) {
        final StopEntitiesDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopEntitiesDetectionJobResult>(){

            @Override
            public StopEntitiesDetectionJobResult call() throws Exception {
                StopEntitiesDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStopEntitiesDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopKeyPhrasesDetectionJobResult> stopKeyPhrasesDetectionJobAsync(StopKeyPhrasesDetectionJobRequest request) {
        return this.stopKeyPhrasesDetectionJobAsync(request, null);
    }

    @Override
    public Future<StopKeyPhrasesDetectionJobResult> stopKeyPhrasesDetectionJobAsync(StopKeyPhrasesDetectionJobRequest request, final AsyncHandler<StopKeyPhrasesDetectionJobRequest, StopKeyPhrasesDetectionJobResult> asyncHandler) {
        final StopKeyPhrasesDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopKeyPhrasesDetectionJobResult>(){

            @Override
            public StopKeyPhrasesDetectionJobResult call() throws Exception {
                StopKeyPhrasesDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStopKeyPhrasesDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopSentimentDetectionJobResult> stopSentimentDetectionJobAsync(StopSentimentDetectionJobRequest request) {
        return this.stopSentimentDetectionJobAsync(request, null);
    }

    @Override
    public Future<StopSentimentDetectionJobResult> stopSentimentDetectionJobAsync(StopSentimentDetectionJobRequest request, final AsyncHandler<StopSentimentDetectionJobRequest, StopSentimentDetectionJobResult> asyncHandler) {
        final StopSentimentDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopSentimentDetectionJobResult>(){

            @Override
            public StopSentimentDetectionJobResult call() throws Exception {
                StopSentimentDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStopSentimentDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

