/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestar.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codestar.model.Code;

@SdkInternalApi
public class CodeMarshaller {
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final CodeMarshaller instance = new CodeMarshaller();

    public static CodeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Code code, ProtocolMarshaller protocolMarshaller) {
        if (code == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(code.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(code.getDestination(), DESTINATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

