/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestar.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codestar.model.ToolchainSource;
import com.amazonaws.services.codestar.model.transform.ToolchainMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Toolchain
implements Serializable,
Cloneable,
StructuredPojo {
    private ToolchainSource source;
    private String roleArn;
    private Map<String, String> stackParameters;

    public void setSource(ToolchainSource source) {
        this.source = source;
    }

    public ToolchainSource getSource() {
        return this.source;
    }

    public Toolchain withSource(ToolchainSource source) {
        this.setSource(source);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Toolchain withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public Map<String, String> getStackParameters() {
        return this.stackParameters;
    }

    public void setStackParameters(Map<String, String> stackParameters) {
        this.stackParameters = stackParameters;
    }

    public Toolchain withStackParameters(Map<String, String> stackParameters) {
        this.setStackParameters(stackParameters);
        return this;
    }

    public Toolchain addStackParametersEntry(String key, String value) {
        if (null == this.stackParameters) {
            this.stackParameters = new HashMap<String, String>();
        }
        if (this.stackParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.stackParameters.put(key, value);
        return this;
    }

    public Toolchain clearStackParametersEntries() {
        this.stackParameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getStackParameters() != null) {
            sb.append("StackParameters: ").append(this.getStackParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Toolchain)) {
            return false;
        }
        Toolchain other = (Toolchain)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getStackParameters() == null ^ this.getStackParameters() == null) {
            return false;
        }
        return other.getStackParameters() == null || other.getStackParameters().equals(this.getStackParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getStackParameters() == null ? 0 : this.getStackParameters().hashCode());
        return hashCode;
    }

    public Toolchain clone() {
        try {
            return (Toolchain)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ToolchainMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

