/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.autoscalingplans.model.TagFilter;
import com.amazonaws.services.autoscalingplans.model.transform.ApplicationSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String cloudFormationStackARN;
    private List<TagFilter> tagFilters;

    public void setCloudFormationStackARN(String cloudFormationStackARN) {
        this.cloudFormationStackARN = cloudFormationStackARN;
    }

    public String getCloudFormationStackARN() {
        return this.cloudFormationStackARN;
    }

    public ApplicationSource withCloudFormationStackARN(String cloudFormationStackARN) {
        this.setCloudFormationStackARN(cloudFormationStackARN);
        return this;
    }

    public List<TagFilter> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(Collection<TagFilter> tagFilters) {
        if (tagFilters == null) {
            this.tagFilters = null;
            return;
        }
        this.tagFilters = new ArrayList<TagFilter>(tagFilters);
    }

    public ApplicationSource withTagFilters(TagFilter ... tagFilters) {
        if (this.tagFilters == null) {
            this.setTagFilters(new ArrayList<TagFilter>(tagFilters.length));
        }
        for (TagFilter ele : tagFilters) {
            this.tagFilters.add(ele);
        }
        return this;
    }

    public ApplicationSource withTagFilters(Collection<TagFilter> tagFilters) {
        this.setTagFilters(tagFilters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCloudFormationStackARN() != null) {
            sb.append("CloudFormationStackARN: ").append(this.getCloudFormationStackARN()).append(",");
        }
        if (this.getTagFilters() != null) {
            sb.append("TagFilters: ").append(this.getTagFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSource)) {
            return false;
        }
        ApplicationSource other = (ApplicationSource)obj;
        if (other.getCloudFormationStackARN() == null ^ this.getCloudFormationStackARN() == null) {
            return false;
        }
        if (other.getCloudFormationStackARN() != null && !other.getCloudFormationStackARN().equals(this.getCloudFormationStackARN())) {
            return false;
        }
        if (other.getTagFilters() == null ^ this.getTagFilters() == null) {
            return false;
        }
        return other.getTagFilters() == null || other.getTagFilters().equals(this.getTagFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCloudFormationStackARN() == null ? 0 : this.getCloudFormationStackARN().hashCode());
        hashCode = 31 * hashCode + (this.getTagFilters() == null ? 0 : this.getTagFilters().hashCode());
        return hashCode;
    }

    public ApplicationSource clone() {
        try {
            return (ApplicationSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

