/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appsync.model.OpenIDConnectConfig;

@SdkInternalApi
public class OpenIDConnectConfigMarshaller {
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuer").build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientId").build();
    private static final MarshallingInfo<Long> IATTTL_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iatTTL").build();
    private static final MarshallingInfo<Long> AUTHTTL_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authTTL").build();
    private static final OpenIDConnectConfigMarshaller instance = new OpenIDConnectConfigMarshaller();

    public static OpenIDConnectConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(OpenIDConnectConfig openIDConnectConfig, ProtocolMarshaller protocolMarshaller) {
        if (openIDConnectConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(openIDConnectConfig.getIssuer(), ISSUER_BINDING);
            protocolMarshaller.marshall(openIDConnectConfig.getClientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(openIDConnectConfig.getIatTTL(), IATTTL_BINDING);
            protocolMarshaller.marshall(openIDConnectConfig.getAuthTTL(), AUTHTTL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

