/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appsync.model.transform.OpenIDConnectConfigMarshaller;
import java.io.Serializable;

public class OpenIDConnectConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String issuer;
    private String clientId;
    private Long iatTTL;
    private Long authTTL;

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public OpenIDConnectConfig withIssuer(String issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OpenIDConnectConfig withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public void setIatTTL(Long iatTTL) {
        this.iatTTL = iatTTL;
    }

    public Long getIatTTL() {
        return this.iatTTL;
    }

    public OpenIDConnectConfig withIatTTL(Long iatTTL) {
        this.setIatTTL(iatTTL);
        return this;
    }

    public void setAuthTTL(Long authTTL) {
        this.authTTL = authTTL;
    }

    public Long getAuthTTL() {
        return this.authTTL;
    }

    public OpenIDConnectConfig withAuthTTL(Long authTTL) {
        this.setAuthTTL(authTTL);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer()).append(",");
        }
        if (this.getClientId() != null) {
            sb.append("ClientId: ").append(this.getClientId()).append(",");
        }
        if (this.getIatTTL() != null) {
            sb.append("IatTTL: ").append(this.getIatTTL()).append(",");
        }
        if (this.getAuthTTL() != null) {
            sb.append("AuthTTL: ").append(this.getAuthTTL());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIDConnectConfig)) {
            return false;
        }
        OpenIDConnectConfig other = (OpenIDConnectConfig)obj;
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        if (other.getIssuer() != null && !other.getIssuer().equals(this.getIssuer())) {
            return false;
        }
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getIatTTL() == null ^ this.getIatTTL() == null) {
            return false;
        }
        if (other.getIatTTL() != null && !other.getIatTTL().equals(this.getIatTTL())) {
            return false;
        }
        if (other.getAuthTTL() == null ^ this.getAuthTTL() == null) {
            return false;
        }
        return other.getAuthTTL() == null || other.getAuthTTL().equals(this.getAuthTTL());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getIatTTL() == null ? 0 : this.getIatTTL().hashCode());
        hashCode = 31 * hashCode + (this.getAuthTTL() == null ? 0 : this.getAuthTTL().hashCode());
        return hashCode;
    }

    public OpenIDConnectConfig clone() {
        try {
            return (OpenIDConnectConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenIDConnectConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

