/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleemail.model.CreateConfigurationSetTrackingOptionsRequest;
import com.amazonaws.services.simpleemail.model.TrackingOptions;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateConfigurationSetTrackingOptionsRequestMarshaller
implements Marshaller<Request<CreateConfigurationSetTrackingOptionsRequest>, CreateConfigurationSetTrackingOptionsRequest> {
    @Override
    public Request<CreateConfigurationSetTrackingOptionsRequest> marshall(CreateConfigurationSetTrackingOptionsRequest createConfigurationSetTrackingOptionsRequest) {
        TrackingOptions trackingOptions;
        if (createConfigurationSetTrackingOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateConfigurationSetTrackingOptionsRequest> request = new DefaultRequest<CreateConfigurationSetTrackingOptionsRequest>(createConfigurationSetTrackingOptionsRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateConfigurationSetTrackingOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createConfigurationSetTrackingOptionsRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(createConfigurationSetTrackingOptionsRequest.getConfigurationSetName()));
        }
        if ((trackingOptions = createConfigurationSetTrackingOptionsRequest.getTrackingOptions()) != null && trackingOptions.getCustomRedirectDomain() != null) {
            request.addParameter("TrackingOptions.CustomRedirectDomain", StringUtils.fromString(trackingOptions.getCustomRedirectDomain()));
        }
        return request;
    }
}

