/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.TextDetection;

@SdkInternalApi
public class TextDetectionMarshaller {
    private static final MarshallingInfo<String> DETECTEDTEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetectedText").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Integer> ID_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<Integer> PARENTID_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentId").build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").build();
    private static final MarshallingInfo<StructuredPojo> GEOMETRY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Geometry").build();
    private static final TextDetectionMarshaller instance = new TextDetectionMarshaller();

    public static TextDetectionMarshaller getInstance() {
        return instance;
    }

    public void marshall(TextDetection textDetection, ProtocolMarshaller protocolMarshaller) {
        if (textDetection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(textDetection.getDetectedText(), DETECTEDTEXT_BINDING);
            protocolMarshaller.marshall(textDetection.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(textDetection.getId(), ID_BINDING);
            protocolMarshaller.marshall(textDetection.getParentId(), PARENTID_BINDING);
            protocolMarshaller.marshall(textDetection.getConfidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall(textDetection.getGeometry(), GEOMETRY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

