/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.DeploymentConfiguration;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.NetworkConfiguration;
import com.amazonaws.services.ecs.model.PlacementConstraint;
import com.amazonaws.services.ecs.model.PlacementStrategy;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateServiceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String serviceName;
    private String taskDefinition;
    private SdkInternalList<LoadBalancer> loadBalancers;
    private Integer desiredCount;
    private String clientToken;
    private String role;
    private DeploymentConfiguration deploymentConfiguration;
    private SdkInternalList<PlacementConstraint> placementConstraints;
    private SdkInternalList<PlacementStrategy> placementStrategy;
    private NetworkConfiguration networkConfiguration;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CreateServiceRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public CreateServiceRequest withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public CreateServiceRequest withTaskDefinition(String taskDefinition) {
        this.setTaskDefinition(taskDefinition);
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new SdkInternalList();
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        this.loadBalancers = new SdkInternalList<LoadBalancer>(loadBalancers);
    }

    public CreateServiceRequest withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.loadBalancers == null) {
            this.setLoadBalancers(new SdkInternalList<LoadBalancer>(loadBalancers.length));
        }
        for (LoadBalancer ele : loadBalancers) {
            this.loadBalancers.add(ele);
        }
        return this;
    }

    public CreateServiceRequest withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        this.setLoadBalancers(loadBalancers);
        return this;
    }

    public void setDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
    }

    public Integer getDesiredCount() {
        return this.desiredCount;
    }

    public CreateServiceRequest withDesiredCount(Integer desiredCount) {
        this.setDesiredCount(desiredCount);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateServiceRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public CreateServiceRequest withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public CreateServiceRequest withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.setDeploymentConfiguration(deploymentConfiguration);
        return this;
    }

    public List<PlacementConstraint> getPlacementConstraints() {
        if (this.placementConstraints == null) {
            this.placementConstraints = new SdkInternalList();
        }
        return this.placementConstraints;
    }

    public void setPlacementConstraints(Collection<PlacementConstraint> placementConstraints) {
        if (placementConstraints == null) {
            this.placementConstraints = null;
            return;
        }
        this.placementConstraints = new SdkInternalList<PlacementConstraint>(placementConstraints);
    }

    public CreateServiceRequest withPlacementConstraints(PlacementConstraint ... placementConstraints) {
        if (this.placementConstraints == null) {
            this.setPlacementConstraints(new SdkInternalList<PlacementConstraint>(placementConstraints.length));
        }
        for (PlacementConstraint ele : placementConstraints) {
            this.placementConstraints.add(ele);
        }
        return this;
    }

    public CreateServiceRequest withPlacementConstraints(Collection<PlacementConstraint> placementConstraints) {
        this.setPlacementConstraints(placementConstraints);
        return this;
    }

    public List<PlacementStrategy> getPlacementStrategy() {
        if (this.placementStrategy == null) {
            this.placementStrategy = new SdkInternalList();
        }
        return this.placementStrategy;
    }

    public void setPlacementStrategy(Collection<PlacementStrategy> placementStrategy) {
        if (placementStrategy == null) {
            this.placementStrategy = null;
            return;
        }
        this.placementStrategy = new SdkInternalList<PlacementStrategy>(placementStrategy);
    }

    public CreateServiceRequest withPlacementStrategy(PlacementStrategy ... placementStrategy) {
        if (this.placementStrategy == null) {
            this.setPlacementStrategy(new SdkInternalList<PlacementStrategy>(placementStrategy.length));
        }
        for (PlacementStrategy ele : placementStrategy) {
            this.placementStrategy.add(ele);
        }
        return this;
    }

    public CreateServiceRequest withPlacementStrategy(Collection<PlacementStrategy> placementStrategy) {
        this.setPlacementStrategy(placementStrategy);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public CreateServiceRequest withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: ").append(this.getTaskDefinition()).append(",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.getLoadBalancers()).append(",");
        }
        if (this.getDesiredCount() != null) {
            sb.append("DesiredCount: ").append(this.getDesiredCount()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getDeploymentConfiguration() != null) {
            sb.append("DeploymentConfiguration: ").append(this.getDeploymentConfiguration()).append(",");
        }
        if (this.getPlacementConstraints() != null) {
            sb.append("PlacementConstraints: ").append(this.getPlacementConstraints()).append(",");
        }
        if (this.getPlacementStrategy() != null) {
            sb.append("PlacementStrategy: ").append(this.getPlacementStrategy()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getDesiredCount() == null ^ this.getDesiredCount() == null) {
            return false;
        }
        if (other.getDesiredCount() != null && !other.getDesiredCount().equals(this.getDesiredCount())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getDeploymentConfiguration() == null ^ this.getDeploymentConfiguration() == null) {
            return false;
        }
        if (other.getDeploymentConfiguration() != null && !other.getDeploymentConfiguration().equals(this.getDeploymentConfiguration())) {
            return false;
        }
        if (other.getPlacementConstraints() == null ^ this.getPlacementConstraints() == null) {
            return false;
        }
        if (other.getPlacementConstraints() != null && !other.getPlacementConstraints().equals(this.getPlacementConstraints())) {
            return false;
        }
        if (other.getPlacementStrategy() == null ^ this.getPlacementStrategy() == null) {
            return false;
        }
        if (other.getPlacementStrategy() != null && !other.getPlacementStrategy().equals(this.getPlacementStrategy())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        return other.getNetworkConfiguration() == null || other.getNetworkConfiguration().equals(this.getNetworkConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCount() == null ? 0 : this.getDesiredCount().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfiguration() == null ? 0 : this.getDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementConstraints() == null ? 0 : this.getPlacementConstraints().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementStrategy() == null ? 0 : this.getPlacementStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public CreateServiceRequest clone() {
        return (CreateServiceRequest)super.clone();
    }
}

