/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.workspaces.AmazonWorkspacesAsync;
import com.amazonaws.services.workspaces.AmazonWorkspacesAsyncClientBuilder;
import com.amazonaws.services.workspaces.AmazonWorkspacesClient;
import com.amazonaws.services.workspaces.model.CreateTagsRequest;
import com.amazonaws.services.workspaces.model.CreateTagsResult;
import com.amazonaws.services.workspaces.model.CreateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.CreateWorkspacesResult;
import com.amazonaws.services.workspaces.model.DeleteTagsRequest;
import com.amazonaws.services.workspaces.model.DeleteTagsResult;
import com.amazonaws.services.workspaces.model.DescribeTagsRequest;
import com.amazonaws.services.workspaces.model.DescribeTagsResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesConnectionStatusResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesResult;
import com.amazonaws.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import com.amazonaws.services.workspaces.model.ModifyWorkspacePropertiesResult;
import com.amazonaws.services.workspaces.model.RebootWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebootWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesResult;
import com.amazonaws.services.workspaces.model.StartWorkspacesRequest;
import com.amazonaws.services.workspaces.model.StartWorkspacesResult;
import com.amazonaws.services.workspaces.model.StopWorkspacesRequest;
import com.amazonaws.services.workspaces.model.StopWorkspacesResult;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonWorkspacesAsyncClient
extends AmazonWorkspacesClient
implements AmazonWorkspacesAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonWorkspacesAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonWorkspacesAsyncClientBuilder asyncBuilder() {
        return AmazonWorkspacesAsyncClientBuilder.standard();
    }

    AmazonWorkspacesAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        final CreateTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeCreateTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkspacesResult> createWorkspacesAsync(CreateWorkspacesRequest request) {
        return this.createWorkspacesAsync(request, null);
    }

    @Override
    public Future<CreateWorkspacesResult> createWorkspacesAsync(CreateWorkspacesRequest request, final AsyncHandler<CreateWorkspacesRequest, CreateWorkspacesResult> asyncHandler) {
        final CreateWorkspacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkspacesResult>(){

            @Override
            public CreateWorkspacesResult call() throws Exception {
                CreateWorkspacesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeCreateWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        final DescribeTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeDescribeTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(DescribeWorkspaceBundlesRequest request) {
        return this.describeWorkspaceBundlesAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(DescribeWorkspaceBundlesRequest request, final AsyncHandler<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResult> asyncHandler) {
        final DescribeWorkspaceBundlesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkspaceBundlesResult>(){

            @Override
            public DescribeWorkspaceBundlesResult call() throws Exception {
                DescribeWorkspaceBundlesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeDescribeWorkspaceBundles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync() {
        return this.describeWorkspaceBundlesAsync(new DescribeWorkspaceBundlesRequest());
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(AsyncHandler<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResult> asyncHandler) {
        return this.describeWorkspaceBundlesAsync(new DescribeWorkspaceBundlesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(DescribeWorkspaceDirectoriesRequest request) {
        return this.describeWorkspaceDirectoriesAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(DescribeWorkspaceDirectoriesRequest request, final AsyncHandler<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResult> asyncHandler) {
        final DescribeWorkspaceDirectoriesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkspaceDirectoriesResult>(){

            @Override
            public DescribeWorkspaceDirectoriesResult call() throws Exception {
                DescribeWorkspaceDirectoriesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeDescribeWorkspaceDirectories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync() {
        return this.describeWorkspaceDirectoriesAsync(new DescribeWorkspaceDirectoriesRequest());
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(AsyncHandler<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResult> asyncHandler) {
        return this.describeWorkspaceDirectoriesAsync(new DescribeWorkspaceDirectoriesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(DescribeWorkspacesRequest request) {
        return this.describeWorkspacesAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(DescribeWorkspacesRequest request, final AsyncHandler<DescribeWorkspacesRequest, DescribeWorkspacesResult> asyncHandler) {
        final DescribeWorkspacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkspacesResult>(){

            @Override
            public DescribeWorkspacesResult call() throws Exception {
                DescribeWorkspacesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeDescribeWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync() {
        return this.describeWorkspacesAsync(new DescribeWorkspacesRequest());
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(AsyncHandler<DescribeWorkspacesRequest, DescribeWorkspacesResult> asyncHandler) {
        return this.describeWorkspacesAsync(new DescribeWorkspacesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeWorkspacesConnectionStatusResult> describeWorkspacesConnectionStatusAsync(DescribeWorkspacesConnectionStatusRequest request) {
        return this.describeWorkspacesConnectionStatusAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspacesConnectionStatusResult> describeWorkspacesConnectionStatusAsync(DescribeWorkspacesConnectionStatusRequest request, final AsyncHandler<DescribeWorkspacesConnectionStatusRequest, DescribeWorkspacesConnectionStatusResult> asyncHandler) {
        final DescribeWorkspacesConnectionStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkspacesConnectionStatusResult>(){

            @Override
            public DescribeWorkspacesConnectionStatusResult call() throws Exception {
                DescribeWorkspacesConnectionStatusResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeDescribeWorkspacesConnectionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyWorkspacePropertiesResult> modifyWorkspacePropertiesAsync(ModifyWorkspacePropertiesRequest request) {
        return this.modifyWorkspacePropertiesAsync(request, null);
    }

    @Override
    public Future<ModifyWorkspacePropertiesResult> modifyWorkspacePropertiesAsync(ModifyWorkspacePropertiesRequest request, final AsyncHandler<ModifyWorkspacePropertiesRequest, ModifyWorkspacePropertiesResult> asyncHandler) {
        final ModifyWorkspacePropertiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyWorkspacePropertiesResult>(){

            @Override
            public ModifyWorkspacePropertiesResult call() throws Exception {
                ModifyWorkspacePropertiesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeModifyWorkspaceProperties(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebootWorkspacesResult> rebootWorkspacesAsync(RebootWorkspacesRequest request) {
        return this.rebootWorkspacesAsync(request, null);
    }

    @Override
    public Future<RebootWorkspacesResult> rebootWorkspacesAsync(RebootWorkspacesRequest request, final AsyncHandler<RebootWorkspacesRequest, RebootWorkspacesResult> asyncHandler) {
        final RebootWorkspacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebootWorkspacesResult>(){

            @Override
            public RebootWorkspacesResult call() throws Exception {
                RebootWorkspacesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeRebootWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebuildWorkspacesResult> rebuildWorkspacesAsync(RebuildWorkspacesRequest request) {
        return this.rebuildWorkspacesAsync(request, null);
    }

    @Override
    public Future<RebuildWorkspacesResult> rebuildWorkspacesAsync(RebuildWorkspacesRequest request, final AsyncHandler<RebuildWorkspacesRequest, RebuildWorkspacesResult> asyncHandler) {
        final RebuildWorkspacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebuildWorkspacesResult>(){

            @Override
            public RebuildWorkspacesResult call() throws Exception {
                RebuildWorkspacesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeRebuildWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartWorkspacesResult> startWorkspacesAsync(StartWorkspacesRequest request) {
        return this.startWorkspacesAsync(request, null);
    }

    @Override
    public Future<StartWorkspacesResult> startWorkspacesAsync(StartWorkspacesRequest request, final AsyncHandler<StartWorkspacesRequest, StartWorkspacesResult> asyncHandler) {
        final StartWorkspacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartWorkspacesResult>(){

            @Override
            public StartWorkspacesResult call() throws Exception {
                StartWorkspacesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeStartWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopWorkspacesResult> stopWorkspacesAsync(StopWorkspacesRequest request) {
        return this.stopWorkspacesAsync(request, null);
    }

    @Override
    public Future<StopWorkspacesResult> stopWorkspacesAsync(StopWorkspacesRequest request, final AsyncHandler<StopWorkspacesRequest, StopWorkspacesResult> asyncHandler) {
        final StopWorkspacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopWorkspacesResult>(){

            @Override
            public StopWorkspacesResult call() throws Exception {
                StopWorkspacesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeStopWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateWorkspacesResult> terminateWorkspacesAsync(TerminateWorkspacesRequest request) {
        return this.terminateWorkspacesAsync(request, null);
    }

    @Override
    public Future<TerminateWorkspacesResult> terminateWorkspacesAsync(TerminateWorkspacesRequest request, final AsyncHandler<TerminateWorkspacesRequest, TerminateWorkspacesResult> asyncHandler) {
        final TerminateWorkspacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TerminateWorkspacesResult>(){

            @Override
            public TerminateWorkspacesResult call() throws Exception {
                TerminateWorkspacesResult result = null;
                try {
                    result = AmazonWorkspacesAsyncClient.this.executeTerminateWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

