/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.IpProtocol;
import com.amazonaws.services.gamelift.model.transform.IpPermissionMarshaller;
import java.io.Serializable;

public class IpPermission
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer fromPort;
    private Integer toPort;
    private String ipRange;
    private String protocol;

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public IpPermission withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public IpPermission withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    public void setIpRange(String ipRange) {
        this.ipRange = ipRange;
    }

    public String getIpRange() {
        return this.ipRange;
    }

    public IpPermission withIpRange(String ipRange) {
        this.setIpRange(ipRange);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public IpPermission withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setProtocol(IpProtocol protocol) {
        this.withProtocol(protocol);
    }

    public IpPermission withProtocol(IpProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFromPort() != null) {
            sb.append("FromPort: ").append(this.getFromPort()).append(",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: ").append(this.getToPort()).append(",");
        }
        if (this.getIpRange() != null) {
            sb.append("IpRange: ").append(this.getIpRange()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getIpRange() == null ^ this.getIpRange() == null) {
            return false;
        }
        if (other.getIpRange() != null && !other.getIpRange().equals(this.getIpRange())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        return other.getProtocol() == null || other.getProtocol().equals(this.getProtocol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getIpRange() == null ? 0 : this.getIpRange().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return hashCode;
    }

    public IpPermission clone() {
        try {
            return (IpPermission)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IpPermissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

