/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dax.model.Subnet;

@SdkInternalApi
public class SubnetMarshaller {
    private static final MarshallingInfo<String> SUBNETIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIdentifier").build();
    private static final MarshallingInfo<String> SUBNETAVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetAvailabilityZone").build();
    private static final SubnetMarshaller instance = new SubnetMarshaller();

    public static SubnetMarshaller getInstance() {
        return instance;
    }

    public void marshall(Subnet subnet, ProtocolMarshaller protocolMarshaller) {
        if (subnet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(subnet.getSubnetIdentifier(), SUBNETIDENTIFIER_BINDING);
            protocolMarshaller.marshall(subnet.getSubnetAvailabilityZone(), SUBNETAVAILABILITYZONE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

