/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudtrail.model.transform.DataResourceMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DataResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private SdkInternalList<String> values;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DataResource withType(String type) {
        this.setType(type);
        return this;
    }

    public List<String> getValues() {
        if (this.values == null) {
            this.values = new SdkInternalList();
        }
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new SdkInternalList<String>(values);
    }

    public DataResource withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new SdkInternalList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public DataResource withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataResource)) {
            return false;
        }
        DataResource other = (DataResource)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public DataResource clone() {
        try {
            return (DataResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

