/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.transform.PartitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Partition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> values;
    private String databaseName;
    private String tableName;
    private Date creationTime;
    private Date lastAccessTime;
    private StorageDescriptor storageDescriptor;
    private Map<String, String> parameters;
    private Date lastAnalyzedTime;

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public Partition withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public Partition withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Partition withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Partition withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Partition withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public Partition withLastAccessTime(Date lastAccessTime) {
        this.setLastAccessTime(lastAccessTime);
        return this;
    }

    public void setStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
    }

    public StorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    public Partition withStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.setStorageDescriptor(storageDescriptor);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Partition withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Partition addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public Partition clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setLastAnalyzedTime(Date lastAnalyzedTime) {
        this.lastAnalyzedTime = lastAnalyzedTime;
    }

    public Date getLastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public Partition withLastAnalyzedTime(Date lastAnalyzedTime) {
        this.setLastAnalyzedTime(lastAnalyzedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastAccessTime() != null) {
            sb.append("LastAccessTime: ").append(this.getLastAccessTime()).append(",");
        }
        if (this.getStorageDescriptor() != null) {
            sb.append("StorageDescriptor: ").append(this.getStorageDescriptor()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getLastAnalyzedTime() != null) {
            sb.append("LastAnalyzedTime: ").append(this.getLastAnalyzedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)obj;
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastAccessTime() == null ^ this.getLastAccessTime() == null) {
            return false;
        }
        if (other.getLastAccessTime() != null && !other.getLastAccessTime().equals(this.getLastAccessTime())) {
            return false;
        }
        if (other.getStorageDescriptor() == null ^ this.getStorageDescriptor() == null) {
            return false;
        }
        if (other.getStorageDescriptor() != null && !other.getStorageDescriptor().equals(this.getStorageDescriptor())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getLastAnalyzedTime() == null ^ this.getLastAnalyzedTime() == null) {
            return false;
        }
        return other.getLastAnalyzedTime() == null || other.getLastAnalyzedTime().equals(this.getLastAnalyzedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastAccessTime() == null ? 0 : this.getLastAccessTime().hashCode());
        hashCode = 31 * hashCode + (this.getStorageDescriptor() == null ? 0 : this.getStorageDescriptor().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getLastAnalyzedTime() == null ? 0 : this.getLastAnalyzedTime().hashCode());
        return hashCode;
    }

    public Partition clone() {
        try {
            return (Partition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

