/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.Difference;

@SdkInternalApi
public class DifferenceMarshaller {
    private static final MarshallingInfo<StructuredPojo> BEFOREBLOB_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("beforeBlob").build();
    private static final MarshallingInfo<StructuredPojo> AFTERBLOB_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("afterBlob").build();
    private static final MarshallingInfo<String> CHANGETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("changeType").build();
    private static final DifferenceMarshaller instance = new DifferenceMarshaller();

    public static DifferenceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Difference difference, ProtocolMarshaller protocolMarshaller) {
        if (difference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(difference.getBeforeBlob(), BEFOREBLOB_BINDING);
            protocolMarshaller.marshall(difference.getAfterBlob(), AFTERBLOB_BINDING);
            protocolMarshaller.marshall(difference.getChangeType(), CHANGETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

