/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.amazonaws.services.clouddirectory.model.SchemaFacet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateObjectRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private List<SchemaFacet> schemaFacets;
    private List<AttributeKeyAndValue> objectAttributeList;
    private ObjectReference parentReference;
    private String linkName;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public CreateObjectRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public List<SchemaFacet> getSchemaFacets() {
        return this.schemaFacets;
    }

    public void setSchemaFacets(Collection<SchemaFacet> schemaFacets) {
        if (schemaFacets == null) {
            this.schemaFacets = null;
            return;
        }
        this.schemaFacets = new ArrayList<SchemaFacet>(schemaFacets);
    }

    public CreateObjectRequest withSchemaFacets(SchemaFacet ... schemaFacets) {
        if (this.schemaFacets == null) {
            this.setSchemaFacets(new ArrayList<SchemaFacet>(schemaFacets.length));
        }
        for (SchemaFacet ele : schemaFacets) {
            this.schemaFacets.add(ele);
        }
        return this;
    }

    public CreateObjectRequest withSchemaFacets(Collection<SchemaFacet> schemaFacets) {
        this.setSchemaFacets(schemaFacets);
        return this;
    }

    public List<AttributeKeyAndValue> getObjectAttributeList() {
        return this.objectAttributeList;
    }

    public void setObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
        if (objectAttributeList == null) {
            this.objectAttributeList = null;
            return;
        }
        this.objectAttributeList = new ArrayList<AttributeKeyAndValue>(objectAttributeList);
    }

    public CreateObjectRequest withObjectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
        if (this.objectAttributeList == null) {
            this.setObjectAttributeList(new ArrayList<AttributeKeyAndValue>(objectAttributeList.length));
        }
        for (AttributeKeyAndValue ele : objectAttributeList) {
            this.objectAttributeList.add(ele);
        }
        return this;
    }

    public CreateObjectRequest withObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
        this.setObjectAttributeList(objectAttributeList);
        return this;
    }

    public void setParentReference(ObjectReference parentReference) {
        this.parentReference = parentReference;
    }

    public ObjectReference getParentReference() {
        return this.parentReference;
    }

    public CreateObjectRequest withParentReference(ObjectReference parentReference) {
        this.setParentReference(parentReference);
        return this;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public CreateObjectRequest withLinkName(String linkName) {
        this.setLinkName(linkName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getSchemaFacets() != null) {
            sb.append("SchemaFacets: ").append(this.getSchemaFacets()).append(",");
        }
        if (this.getObjectAttributeList() != null) {
            sb.append("ObjectAttributeList: ").append(this.getObjectAttributeList()).append(",");
        }
        if (this.getParentReference() != null) {
            sb.append("ParentReference: ").append(this.getParentReference()).append(",");
        }
        if (this.getLinkName() != null) {
            sb.append("LinkName: ").append(this.getLinkName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateObjectRequest)) {
            return false;
        }
        CreateObjectRequest other = (CreateObjectRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getSchemaFacets() == null ^ this.getSchemaFacets() == null) {
            return false;
        }
        if (other.getSchemaFacets() != null && !other.getSchemaFacets().equals(this.getSchemaFacets())) {
            return false;
        }
        if (other.getObjectAttributeList() == null ^ this.getObjectAttributeList() == null) {
            return false;
        }
        if (other.getObjectAttributeList() != null && !other.getObjectAttributeList().equals(this.getObjectAttributeList())) {
            return false;
        }
        if (other.getParentReference() == null ^ this.getParentReference() == null) {
            return false;
        }
        if (other.getParentReference() != null && !other.getParentReference().equals(this.getParentReference())) {
            return false;
        }
        if (other.getLinkName() == null ^ this.getLinkName() == null) {
            return false;
        }
        return other.getLinkName() == null || other.getLinkName().equals(this.getLinkName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaFacets() == null ? 0 : this.getSchemaFacets().hashCode());
        hashCode = 31 * hashCode + (this.getObjectAttributeList() == null ? 0 : this.getObjectAttributeList().hashCode());
        hashCode = 31 * hashCode + (this.getParentReference() == null ? 0 : this.getParentReference().hashCode());
        hashCode = 31 * hashCode + (this.getLinkName() == null ? 0 : this.getLinkName().hashCode());
        return hashCode;
    }

    @Override
    public CreateObjectRequest clone() {
        return (CreateObjectRequest)super.clone();
    }
}

