/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.gamelift.model.Player;
import java.util.Map;

@SdkInternalApi
public class PlayerMarshaller {
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").build();
    private static final MarshallingInfo<Map> PLAYERATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerAttributes").build();
    private static final MarshallingInfo<String> TEAM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Team").build();
    private static final MarshallingInfo<Map> LATENCYINMS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatencyInMs").build();
    private static final PlayerMarshaller instance = new PlayerMarshaller();

    public static PlayerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Player player, ProtocolMarshaller protocolMarshaller) {
        if (player == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(player.getPlayerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall(player.getPlayerAttributes(), PLAYERATTRIBUTES_BINDING);
            protocolMarshaller.marshall(player.getTeam(), TEAM_BINDING);
            protocolMarshaller.marshall(player.getLatencyInMs(), LATENCYINMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

