/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.TypedLinkAttributeDefinition;
import com.amazonaws.services.clouddirectory.model.transform.TypedLinkFacetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TypedLinkFacet
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<TypedLinkAttributeDefinition> attributes;
    private List<String> identityAttributeOrder;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TypedLinkFacet withName(String name) {
        this.setName(name);
        return this;
    }

    public List<TypedLinkAttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<TypedLinkAttributeDefinition> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<TypedLinkAttributeDefinition>(attributes);
    }

    public TypedLinkFacet withAttributes(TypedLinkAttributeDefinition ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<TypedLinkAttributeDefinition>(attributes.length));
        }
        for (TypedLinkAttributeDefinition ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public TypedLinkFacet withAttributes(Collection<TypedLinkAttributeDefinition> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<String> getIdentityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    public void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
        if (identityAttributeOrder == null) {
            this.identityAttributeOrder = null;
            return;
        }
        this.identityAttributeOrder = new ArrayList<String>(identityAttributeOrder);
    }

    public TypedLinkFacet withIdentityAttributeOrder(String ... identityAttributeOrder) {
        if (this.identityAttributeOrder == null) {
            this.setIdentityAttributeOrder(new ArrayList<String>(identityAttributeOrder.length));
        }
        for (String ele : identityAttributeOrder) {
            this.identityAttributeOrder.add(ele);
        }
        return this;
    }

    public TypedLinkFacet withIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
        this.setIdentityAttributeOrder(identityAttributeOrder);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getIdentityAttributeOrder() != null) {
            sb.append("IdentityAttributeOrder: ").append(this.getIdentityAttributeOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkFacet)) {
            return false;
        }
        TypedLinkFacet other = (TypedLinkFacet)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getIdentityAttributeOrder() == null ^ this.getIdentityAttributeOrder() == null) {
            return false;
        }
        return other.getIdentityAttributeOrder() == null || other.getIdentityAttributeOrder().equals(this.getIdentityAttributeOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityAttributeOrder() == null ? 0 : this.getIdentityAttributeOrder().hashCode());
        return hashCode;
    }

    public TypedLinkFacet clone() {
        try {
            return (TypedLinkFacet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkFacetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

