/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cognitoidp.model.ResourceServerType;
import java.util.List;

@SdkInternalApi
public class ResourceServerTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").build();
    private static final MarshallingInfo<String> IDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Identifier").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> SCOPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Scopes").build();
    private static final ResourceServerTypeMarshaller instance = new ResourceServerTypeMarshaller();

    public static ResourceServerTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceServerType resourceServerType, ProtocolMarshaller protocolMarshaller) {
        if (resourceServerType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceServerType.getUserPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(resourceServerType.getIdentifier(), IDENTIFIER_BINDING);
            protocolMarshaller.marshall(resourceServerType.getName(), NAME_BINDING);
            protocolMarshaller.marshall(resourceServerType.getScopes(), SCOPES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

