/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.importexport.model.GetShippingLabelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetShippingLabelRequestMarshaller
implements Marshaller<Request<GetShippingLabelRequest>, GetShippingLabelRequest> {
    @Override
    public Request<GetShippingLabelRequest> marshall(GetShippingLabelRequest getShippingLabelRequest) {
        if (getShippingLabelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetShippingLabelRequest> request = new DefaultRequest<GetShippingLabelRequest>(getShippingLabelRequest, "AmazonImportExport");
        request.addParameter("Action", "GetShippingLabel");
        request.addParameter("Version", "2010-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList jobIdsList = (SdkInternalList)getShippingLabelRequest.getJobIds();
        if (!jobIdsList.isEmpty() || !jobIdsList.isAutoConstruct()) {
            int jobIdsListIndex = 1;
            for (String jobIdsListValue : jobIdsList) {
                if (jobIdsListValue != null) {
                    request.addParameter("jobIds.member." + jobIdsListIndex, StringUtils.fromString(jobIdsListValue));
                }
                ++jobIdsListIndex;
            }
        }
        if (getShippingLabelRequest.getName() != null) {
            request.addParameter("name", StringUtils.fromString(getShippingLabelRequest.getName()));
        }
        if (getShippingLabelRequest.getCompany() != null) {
            request.addParameter("company", StringUtils.fromString(getShippingLabelRequest.getCompany()));
        }
        if (getShippingLabelRequest.getPhoneNumber() != null) {
            request.addParameter("phoneNumber", StringUtils.fromString(getShippingLabelRequest.getPhoneNumber()));
        }
        if (getShippingLabelRequest.getCountry() != null) {
            request.addParameter("country", StringUtils.fromString(getShippingLabelRequest.getCountry()));
        }
        if (getShippingLabelRequest.getStateOrProvince() != null) {
            request.addParameter("stateOrProvince", StringUtils.fromString(getShippingLabelRequest.getStateOrProvince()));
        }
        if (getShippingLabelRequest.getCity() != null) {
            request.addParameter("city", StringUtils.fromString(getShippingLabelRequest.getCity()));
        }
        if (getShippingLabelRequest.getPostalCode() != null) {
            request.addParameter("postalCode", StringUtils.fromString(getShippingLabelRequest.getPostalCode()));
        }
        if (getShippingLabelRequest.getStreet1() != null) {
            request.addParameter("street1", StringUtils.fromString(getShippingLabelRequest.getStreet1()));
        }
        if (getShippingLabelRequest.getStreet2() != null) {
            request.addParameter("street2", StringUtils.fromString(getShippingLabelRequest.getStreet2()));
        }
        if (getShippingLabelRequest.getStreet3() != null) {
            request.addParameter("street3", StringUtils.fromString(getShippingLabelRequest.getStreet3()));
        }
        if (getShippingLabelRequest.getAPIVersion() != null) {
            request.addParameter("APIVersion", StringUtils.fromString(getShippingLabelRequest.getAPIVersion()));
        }
        return request;
    }
}

