/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Job;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListJobsByPipelineResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Job> jobs;
    private String nextPageToken;

    public List<Job> getJobs() {
        if (this.jobs == null) {
            this.jobs = new SdkInternalList();
        }
        return this.jobs;
    }

    public void setJobs(Collection<Job> jobs) {
        if (jobs == null) {
            this.jobs = null;
            return;
        }
        this.jobs = new SdkInternalList<Job>(jobs);
    }

    public ListJobsByPipelineResult withJobs(Job ... jobs) {
        if (this.jobs == null) {
            this.setJobs(new SdkInternalList<Job>(jobs.length));
        }
        for (Job ele : jobs) {
            this.jobs.add(ele);
        }
        return this;
    }

    public ListJobsByPipelineResult withJobs(Collection<Job> jobs) {
        this.setJobs(jobs);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public ListJobsByPipelineResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobs() != null) {
            sb.append("Jobs: ").append(this.getJobs()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsByPipelineResult)) {
            return false;
        }
        ListJobsByPipelineResult other = (ListJobsByPipelineResult)obj;
        if (other.getJobs() == null ^ this.getJobs() == null) {
            return false;
        }
        if (other.getJobs() != null && !other.getJobs().equals(this.getJobs())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobs() == null ? 0 : this.getJobs().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public ListJobsByPipelineResult clone() {
        try {
            return (ListJobsByPipelineResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

