/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.services.ecr.model.Layer;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class LayerJsonUnmarshaller
implements Unmarshaller<Layer, JsonUnmarshallerContext> {
    private static LayerJsonUnmarshaller instance;

    @Override
    public Layer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Layer layer = new Layer();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("layerDigest", targetDepth)) {
                    context.nextToken();
                    layer.setLayerDigest(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("layerAvailability", targetDepth)) {
                    context.nextToken();
                    layer.setLayerAvailability(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("layerSize", targetDepth)) {
                    context.nextToken();
                    layer.setLayerSize(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("mediaType", targetDepth)) {
                    context.nextToken();
                    layer.setMediaType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return layer;
    }

    public static LayerJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LayerJsonUnmarshaller();
        }
        return instance;
    }
}

