/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.thirdparty.apache.http.client.methods.HttpRequestBase;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;

@SdkInternalApi
public final class S3AbortableInputStream
extends SdkFilterInputStream {
    private static final Log LOG = LogFactory.getLog(S3AbortableInputStream.class);
    private final HttpRequestBase httpRequest;
    private final long contentLength;
    private long bytesRead;
    private long markedBytes;
    private boolean eofReached = false;

    public S3AbortableInputStream(InputStream in, HttpRequestBase httpRequest, long contentLength) {
        super(in);
        this.httpRequest = httpRequest;
        this.contentLength = contentLength;
    }

    @Override
    public void abort() {
        super.abort();
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly(this.in, null);
    }

    @Override
    public int available() throws IOException {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        boolean bl = this.eofReached = value == -1;
        if (!this.eofReached) {
            ++this.bytesRead;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = super.read(b, off, len);
        boolean bl = this.eofReached = value == -1;
        if (!this.eofReached) {
            this.bytesRead += (long)value;
        }
        return value;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markedBytes = this.bytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.bytesRead = this.markedBytes;
        this.eofReached = false;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long skipped = super.skip(n);
        if (skipped > 0L) {
            this.bytesRead += skipped;
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        if (this.readAllBytes() || this.isAborted()) {
            super.close();
        } else {
            LOG.warn("Not all bytes were read from the S3ObjectInputStream, aborting HTTP connection. This is likely an error and may result in sub-optimal behavior. Request only the bytes you need via a ranged GET or drain the input stream after use.");
            if (this.httpRequest != null) {
                this.httpRequest.abort();
            }
            IOUtils.closeQuietly(this.in, null);
        }
    }

    @SdkTestInternalApi
    long getBytesRead() {
        return this.bytesRead;
    }

    @SdkTestInternalApi
    boolean isEofReached() {
        return this.eofReached;
    }

    private boolean readAllBytes() {
        return this.bytesRead >= this.contentLength || this.eofReached;
    }
}

