/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.PipelineDescription;
import java.util.List;

@SdkInternalApi
public class PipelineDescriptionMarshaller {
    private static final MarshallingInfo<String> PIPELINEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<List> FIELDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fields").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final PipelineDescriptionMarshaller instance = new PipelineDescriptionMarshaller();

    public static PipelineDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(PipelineDescription pipelineDescription, ProtocolMarshaller protocolMarshaller) {
        if (pipelineDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(pipelineDescription.getPipelineId(), PIPELINEID_BINDING);
            protocolMarshaller.marshall(pipelineDescription.getName(), NAME_BINDING);
            protocolMarshaller.marshall(pipelineDescription.getFields(), FIELDS_BINDING);
            protocolMarshaller.marshall(pipelineDescription.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(pipelineDescription.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

