/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appstream.model.Application;
import java.util.Map;

@SdkInternalApi
public class ApplicationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> ICONURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IconURL").build();
    private static final MarshallingInfo<String> LAUNCHPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchPath").build();
    private static final MarshallingInfo<String> LAUNCHPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchParameters").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<Map> METADATA_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metadata").build();
    private static final ApplicationMarshaller instance = new ApplicationMarshaller();

    public static ApplicationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Application application, ProtocolMarshaller protocolMarshaller) {
        if (application == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(application.getName(), NAME_BINDING);
            protocolMarshaller.marshall(application.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(application.getIconURL(), ICONURL_BINDING);
            protocolMarshaller.marshall(application.getLaunchPath(), LAUNCHPATH_BINDING);
            protocolMarshaller.marshall(application.getLaunchParameters(), LAUNCHPARAMETERS_BINDING);
            protocolMarshaller.marshall(application.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(application.getMetadata(), METADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

