/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.Role;
import com.amazonaws.services.identitymanagement.model.transform.RoleStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class InstanceProfileStaxUnmarshaller
implements Unmarshaller<InstanceProfile, StaxUnmarshallerContext> {
    private static InstanceProfileStaxUnmarshaller instance;

    @Override
    public InstanceProfile unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceProfile instanceProfile = new InstanceProfile();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return instanceProfile;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Path", targetDepth)) {
                    instanceProfile.setPath(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceProfileName", targetDepth)) {
                    instanceProfile.setInstanceProfileName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceProfileId", targetDepth)) {
                    instanceProfile.setInstanceProfileId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Arn", targetDepth)) {
                    instanceProfile.setArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateDate", targetDepth)) {
                    instanceProfile.setCreateDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Roles", targetDepth)) {
                    instanceProfile.withRoles(new ArrayList<Role>());
                    continue;
                }
                if (!context.testExpression("Roles/member", targetDepth)) continue;
                instanceProfile.withRoles(RoleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceProfile;
    }

    public static InstanceProfileStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceProfileStaxUnmarshaller();
        }
        return instance;
    }
}

