/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatch.model.ListDashboardsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListDashboardsRequestMarshaller
implements Marshaller<Request<ListDashboardsRequest>, ListDashboardsRequest> {
    @Override
    public Request<ListDashboardsRequest> marshall(ListDashboardsRequest listDashboardsRequest) {
        if (listDashboardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDashboardsRequest> request = new DefaultRequest<ListDashboardsRequest>(listDashboardsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "ListDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listDashboardsRequest.getDashboardNamePrefix() != null) {
            request.addParameter("DashboardNamePrefix", StringUtils.fromString(listDashboardsRequest.getDashboardNamePrefix()));
        }
        if (listDashboardsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listDashboardsRequest.getNextToken()));
        }
        return request;
    }
}

