/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.dax.AmazonDax;
import com.amazonaws.services.dax.AmazonDaxClientBuilder;
import com.amazonaws.services.dax.model.AmazonDaxException;
import com.amazonaws.services.dax.model.ClusterAlreadyExistsException;
import com.amazonaws.services.dax.model.ClusterNotFoundException;
import com.amazonaws.services.dax.model.ClusterQuotaForCustomerExceededException;
import com.amazonaws.services.dax.model.CreateClusterRequest;
import com.amazonaws.services.dax.model.CreateClusterResult;
import com.amazonaws.services.dax.model.CreateParameterGroupRequest;
import com.amazonaws.services.dax.model.CreateParameterGroupResult;
import com.amazonaws.services.dax.model.CreateSubnetGroupRequest;
import com.amazonaws.services.dax.model.CreateSubnetGroupResult;
import com.amazonaws.services.dax.model.DecreaseReplicationFactorRequest;
import com.amazonaws.services.dax.model.DecreaseReplicationFactorResult;
import com.amazonaws.services.dax.model.DeleteClusterRequest;
import com.amazonaws.services.dax.model.DeleteClusterResult;
import com.amazonaws.services.dax.model.DeleteParameterGroupRequest;
import com.amazonaws.services.dax.model.DeleteParameterGroupResult;
import com.amazonaws.services.dax.model.DeleteSubnetGroupRequest;
import com.amazonaws.services.dax.model.DeleteSubnetGroupResult;
import com.amazonaws.services.dax.model.DescribeClustersRequest;
import com.amazonaws.services.dax.model.DescribeClustersResult;
import com.amazonaws.services.dax.model.DescribeDefaultParametersRequest;
import com.amazonaws.services.dax.model.DescribeDefaultParametersResult;
import com.amazonaws.services.dax.model.DescribeEventsRequest;
import com.amazonaws.services.dax.model.DescribeEventsResult;
import com.amazonaws.services.dax.model.DescribeParameterGroupsRequest;
import com.amazonaws.services.dax.model.DescribeParameterGroupsResult;
import com.amazonaws.services.dax.model.DescribeParametersRequest;
import com.amazonaws.services.dax.model.DescribeParametersResult;
import com.amazonaws.services.dax.model.DescribeSubnetGroupsRequest;
import com.amazonaws.services.dax.model.DescribeSubnetGroupsResult;
import com.amazonaws.services.dax.model.IncreaseReplicationFactorRequest;
import com.amazonaws.services.dax.model.IncreaseReplicationFactorResult;
import com.amazonaws.services.dax.model.InsufficientClusterCapacityException;
import com.amazonaws.services.dax.model.InvalidARNException;
import com.amazonaws.services.dax.model.InvalidClusterStateException;
import com.amazonaws.services.dax.model.InvalidParameterCombinationException;
import com.amazonaws.services.dax.model.InvalidParameterGroupStateException;
import com.amazonaws.services.dax.model.InvalidParameterValueException;
import com.amazonaws.services.dax.model.InvalidSubnetException;
import com.amazonaws.services.dax.model.InvalidVPCNetworkStateException;
import com.amazonaws.services.dax.model.ListTagsRequest;
import com.amazonaws.services.dax.model.ListTagsResult;
import com.amazonaws.services.dax.model.NodeNotFoundException;
import com.amazonaws.services.dax.model.NodeQuotaForClusterExceededException;
import com.amazonaws.services.dax.model.NodeQuotaForCustomerExceededException;
import com.amazonaws.services.dax.model.ParameterGroupAlreadyExistsException;
import com.amazonaws.services.dax.model.ParameterGroupNotFoundException;
import com.amazonaws.services.dax.model.ParameterGroupQuotaExceededException;
import com.amazonaws.services.dax.model.RebootNodeRequest;
import com.amazonaws.services.dax.model.RebootNodeResult;
import com.amazonaws.services.dax.model.SubnetGroupAlreadyExistsException;
import com.amazonaws.services.dax.model.SubnetGroupInUseException;
import com.amazonaws.services.dax.model.SubnetGroupNotFoundException;
import com.amazonaws.services.dax.model.SubnetGroupQuotaExceededException;
import com.amazonaws.services.dax.model.SubnetInUseException;
import com.amazonaws.services.dax.model.SubnetQuotaExceededException;
import com.amazonaws.services.dax.model.TagNotFoundException;
import com.amazonaws.services.dax.model.TagQuotaPerResourceExceededException;
import com.amazonaws.services.dax.model.TagResourceRequest;
import com.amazonaws.services.dax.model.TagResourceResult;
import com.amazonaws.services.dax.model.UntagResourceRequest;
import com.amazonaws.services.dax.model.UntagResourceResult;
import com.amazonaws.services.dax.model.UpdateClusterRequest;
import com.amazonaws.services.dax.model.UpdateClusterResult;
import com.amazonaws.services.dax.model.UpdateParameterGroupRequest;
import com.amazonaws.services.dax.model.UpdateParameterGroupResult;
import com.amazonaws.services.dax.model.UpdateSubnetGroupRequest;
import com.amazonaws.services.dax.model.UpdateSubnetGroupResult;
import com.amazonaws.services.dax.model.transform.CreateClusterRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.CreateClusterResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.CreateParameterGroupRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.CreateParameterGroupResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.CreateSubnetGroupRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.CreateSubnetGroupResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DecreaseReplicationFactorRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DecreaseReplicationFactorResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DeleteClusterRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DeleteClusterResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DeleteParameterGroupRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DeleteParameterGroupResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DeleteSubnetGroupRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DeleteSubnetGroupResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DescribeClustersRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DescribeClustersResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DescribeDefaultParametersRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DescribeDefaultParametersResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DescribeEventsRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DescribeEventsResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DescribeParameterGroupsRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DescribeParameterGroupsResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DescribeParametersRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DescribeParametersResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.DescribeSubnetGroupsRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.DescribeSubnetGroupsResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.IncreaseReplicationFactorRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.IncreaseReplicationFactorResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.ListTagsRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.ListTagsResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.RebootNodeRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.RebootNodeResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.UpdateClusterRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.UpdateClusterResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.UpdateParameterGroupRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.UpdateParameterGroupResultJsonUnmarshaller;
import com.amazonaws.services.dax.model.transform.UpdateSubnetGroupRequestProtocolMarshaller;
import com.amazonaws.services.dax.model.transform.UpdateSubnetGroupResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;

@ThreadSafe
public class AmazonDaxClient
extends AmazonWebServiceClient
implements AmazonDax {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDax.class);
    private static final String DEFAULT_SIGNING_NAME = "dax";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetQuotaExceededFault").withModeledClass(SubnetQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupNotFoundFault").withModeledClass(SubnetGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupQuotaExceededFault").withModeledClass(SubnetGroupQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidVPCNetworkStateFault").withModeledClass(InvalidVPCNetworkStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupAlreadyExistsFault").withModeledClass(ParameterGroupAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetInUse").withModeledClass(SubnetInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterNotFoundFault").withModeledClass(ClusterNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeNotFoundFault").withModeledClass(NodeNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterCombinationException").withModeledClass(InvalidParameterCombinationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeQuotaForCustomerExceededFault").withModeledClass(NodeQuotaForCustomerExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClusterStateFault").withModeledClass(InvalidClusterStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientClusterCapacityFault").withModeledClass(InsufficientClusterCapacityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagNotFoundFault").withModeledClass(TagNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidARNFault").withModeledClass(InvalidARNException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagQuotaPerResourceExceeded").withModeledClass(TagQuotaPerResourceExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterQuotaForCustomerExceededFault").withModeledClass(ClusterQuotaForCustomerExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupInUseFault").withModeledClass(SubnetGroupInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterGroupStateFault").withModeledClass(InvalidParameterGroupStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupNotFoundFault").withModeledClass(ParameterGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSubnet").withModeledClass(InvalidSubnetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterAlreadyExistsFault").withModeledClass(ClusterAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeQuotaForClusterExceededFault").withModeledClass(NodeQuotaForClusterExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupQuotaExceededFault").withModeledClass(ParameterGroupQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupAlreadyExistsFault").withModeledClass(SubnetGroupAlreadyExistsException.class)).withBaseServiceExceptionClass(AmazonDaxException.class));

    public static AmazonDaxClientBuilder builder() {
        return AmazonDaxClientBuilder.standard();
    }

    AmazonDaxClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("dax.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/dax/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/dax/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateClusterResult executeCreateCluster(CreateClusterRequest createClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateClusterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateClusterResult createClusterResult = (CreateClusterResult)response.getAwsResponse();
            return createClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateParameterGroupResult createParameterGroup(CreateParameterGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateParameterGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateParameterGroupResult executeCreateParameterGroup(CreateParameterGroupRequest createParameterGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createParameterGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateParameterGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateParameterGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createParameterGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateParameterGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateParameterGroupResult createParameterGroupResult = (CreateParameterGroupResult)response.getAwsResponse();
            return createParameterGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSubnetGroupResult createSubnetGroup(CreateSubnetGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateSubnetGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSubnetGroupResult executeCreateSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSubnetGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSubnetGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSubnetGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createSubnetGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateSubnetGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSubnetGroupResult createSubnetGroupResult = (CreateSubnetGroupResult)response.getAwsResponse();
            return createSubnetGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DecreaseReplicationFactorResult decreaseReplicationFactor(DecreaseReplicationFactorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDecreaseReplicationFactor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DecreaseReplicationFactorResult executeDecreaseReplicationFactor(DecreaseReplicationFactorRequest decreaseReplicationFactorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(decreaseReplicationFactorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DecreaseReplicationFactorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DecreaseReplicationFactorRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(decreaseReplicationFactorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DecreaseReplicationFactorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DecreaseReplicationFactorResult decreaseReplicationFactorResult = (DecreaseReplicationFactorResult)response.getAwsResponse();
            return decreaseReplicationFactorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteClusterResult executeDeleteCluster(DeleteClusterRequest deleteClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteClusterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteClusterResult deleteClusterResult = (DeleteClusterResult)response.getAwsResponse();
            return deleteClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteParameterGroupResult deleteParameterGroup(DeleteParameterGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteParameterGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteParameterGroupResult executeDeleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteParameterGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteParameterGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteParameterGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteParameterGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteParameterGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteParameterGroupResult deleteParameterGroupResult = (DeleteParameterGroupResult)response.getAwsResponse();
            return deleteParameterGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSubnetGroupResult deleteSubnetGroup(DeleteSubnetGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteSubnetGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSubnetGroupResult executeDeleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubnetGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubnetGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubnetGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteSubnetGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteSubnetGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubnetGroupResult deleteSubnetGroupResult = (DeleteSubnetGroupResult)response.getAwsResponse();
            return deleteSubnetGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeClustersResult describeClusters(DescribeClustersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeClusters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeClustersResult executeDescribeClusters(DescribeClustersRequest describeClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClustersRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeClustersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeClustersResult describeClustersResult = (DescribeClustersResult)response.getAwsResponse();
            return describeClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDefaultParametersResult describeDefaultParameters(DescribeDefaultParametersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeDefaultParameters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDefaultParametersResult executeDescribeDefaultParameters(DescribeDefaultParametersRequest describeDefaultParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDefaultParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDefaultParametersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDefaultParametersRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeDefaultParametersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDefaultParametersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDefaultParametersResult describeDefaultParametersResult = (DescribeDefaultParametersResult)response.getAwsResponse();
            return describeDefaultParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventsResult executeDescribeEvents(DescribeEventsRequest describeEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventsResult describeEventsResult = (DescribeEventsResult)response.getAwsResponse();
            return describeEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeParameterGroupsResult describeParameterGroups(DescribeParameterGroupsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeParameterGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeParameterGroupsResult executeDescribeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeParameterGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeParameterGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeParameterGroupsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeParameterGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeParameterGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeParameterGroupsResult describeParameterGroupsResult = (DescribeParameterGroupsResult)response.getAwsResponse();
            return describeParameterGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeParametersResult describeParameters(DescribeParametersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeParameters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeParametersResult executeDescribeParameters(DescribeParametersRequest describeParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeParametersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeParametersRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeParametersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeParametersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeParametersResult describeParametersResult = (DescribeParametersResult)response.getAwsResponse();
            return describeParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSubnetGroupsResult describeSubnetGroups(DescribeSubnetGroupsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeSubnetGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSubnetGroupsResult executeDescribeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSubnetGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSubnetGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSubnetGroupsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeSubnetGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeSubnetGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSubnetGroupsResult describeSubnetGroupsResult = (DescribeSubnetGroupsResult)response.getAwsResponse();
            return describeSubnetGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public IncreaseReplicationFactorResult increaseReplicationFactor(IncreaseReplicationFactorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeIncreaseReplicationFactor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final IncreaseReplicationFactorResult executeIncreaseReplicationFactor(IncreaseReplicationFactorRequest increaseReplicationFactorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(increaseReplicationFactorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<IncreaseReplicationFactorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new IncreaseReplicationFactorRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(increaseReplicationFactorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new IncreaseReplicationFactorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            IncreaseReplicationFactorResult increaseReplicationFactorResult = (IncreaseReplicationFactorResult)response.getAwsResponse();
            return increaseReplicationFactorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsResult executeListTags(ListTagsRequest listTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsResult listTagsResult = (ListTagsResult)response.getAwsResponse();
            return listTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RebootNodeResult rebootNode(RebootNodeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRebootNode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RebootNodeResult executeRebootNode(RebootNodeRequest rebootNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rebootNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RebootNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RebootNodeRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(rebootNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RebootNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RebootNodeResult rebootNodeResult = (RebootNodeResult)response.getAwsResponse();
            return rebootNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateClusterResult updateCluster(UpdateClusterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateClusterResult executeUpdateCluster(UpdateClusterRequest updateClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateClusterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateClusterResult updateClusterResult = (UpdateClusterResult)response.getAwsResponse();
            return updateClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateParameterGroupResult updateParameterGroup(UpdateParameterGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateParameterGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateParameterGroupResult executeUpdateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateParameterGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateParameterGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateParameterGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateParameterGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateParameterGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateParameterGroupResult updateParameterGroupResult = (UpdateParameterGroupResult)response.getAwsResponse();
            return updateParameterGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSubnetGroupResult updateSubnetGroup(UpdateSubnetGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateSubnetGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSubnetGroupResult executeUpdateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSubnetGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSubnetGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSubnetGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateSubnetGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateSubnetGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSubnetGroupResult updateSubnetGroupResult = (UpdateSubnetGroupResult)response.getAwsResponse();
            return updateSubnetGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

