/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.services.appstream.model.Stack;
import com.amazonaws.services.appstream.model.StackError;
import com.amazonaws.services.appstream.model.StorageConnector;
import com.amazonaws.services.appstream.model.transform.StackErrorJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.StorageConnectorJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import java.util.Date;

public class StackJsonUnmarshaller
implements Unmarshaller<Stack, JsonUnmarshallerContext> {
    private static StackJsonUnmarshaller instance;

    @Override
    public Stack unmarshall(JsonUnmarshallerContext context) throws Exception {
        Stack stack = new Stack();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    stack.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    stack.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    stack.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    stack.setDisplayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    stack.setCreatedTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("StorageConnectors", targetDepth)) {
                    context.nextToken();
                    stack.setStorageConnectors(new ListUnmarshaller<StorageConnector>(StorageConnectorJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("StackErrors", targetDepth)) {
                    context.nextToken();
                    stack.setStackErrors(new ListUnmarshaller<StackError>(StackErrorJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return stack;
    }

    public static StackJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StackJsonUnmarshaller();
        }
        return instance;
    }
}

