/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.GeoLocation;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSetFailover;
import com.amazonaws.services.route53.model.ResourceRecordSetRegion;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResourceRecordSet
implements Serializable,
Cloneable {
    private String name;
    private String type;
    private String setIdentifier;
    private Long weight;
    private String region;
    private GeoLocation geoLocation;
    private String failover;
    private Long tTL;
    private SdkInternalList<ResourceRecord> resourceRecords;
    private AliasTarget aliasTarget;
    private String healthCheckId;
    private String trafficPolicyInstanceId;

    public ResourceRecordSet() {
    }

    public ResourceRecordSet(String name, String type) {
        this.setName(name);
        this.setType(type);
    }

    public ResourceRecordSet(String name, RRType type) {
        this.setName(name);
        this.setType(type.toString());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceRecordSet withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ResourceRecordSet withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(RRType type) {
        this.type = type.toString();
    }

    public ResourceRecordSet withType(RRType type) {
        this.setType(type);
        return this;
    }

    public void setSetIdentifier(String setIdentifier) {
        this.setIdentifier = setIdentifier;
    }

    public String getSetIdentifier() {
        return this.setIdentifier;
    }

    public ResourceRecordSet withSetIdentifier(String setIdentifier) {
        this.setSetIdentifier(setIdentifier);
        return this;
    }

    public void setWeight(Long weight) {
        this.weight = weight;
    }

    public Long getWeight() {
        return this.weight;
    }

    public ResourceRecordSet withWeight(Long weight) {
        this.setWeight(weight);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public ResourceRecordSet withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setRegion(ResourceRecordSetRegion region) {
        this.region = region.toString();
    }

    public ResourceRecordSet withRegion(ResourceRecordSetRegion region) {
        this.setRegion(region);
        return this;
    }

    public void setGeoLocation(GeoLocation geoLocation) {
        this.geoLocation = geoLocation;
    }

    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    public ResourceRecordSet withGeoLocation(GeoLocation geoLocation) {
        this.setGeoLocation(geoLocation);
        return this;
    }

    public void setFailover(String failover) {
        this.failover = failover;
    }

    public String getFailover() {
        return this.failover;
    }

    public ResourceRecordSet withFailover(String failover) {
        this.setFailover(failover);
        return this;
    }

    public void setFailover(ResourceRecordSetFailover failover) {
        this.failover = failover.toString();
    }

    public ResourceRecordSet withFailover(ResourceRecordSetFailover failover) {
        this.setFailover(failover);
        return this;
    }

    public void setTTL(Long tTL) {
        this.tTL = tTL;
    }

    public Long getTTL() {
        return this.tTL;
    }

    public ResourceRecordSet withTTL(Long tTL) {
        this.setTTL(tTL);
        return this;
    }

    public List<ResourceRecord> getResourceRecords() {
        if (this.resourceRecords == null) {
            this.resourceRecords = new SdkInternalList();
        }
        return this.resourceRecords;
    }

    public void setResourceRecords(Collection<ResourceRecord> resourceRecords) {
        if (resourceRecords == null) {
            this.resourceRecords = null;
            return;
        }
        this.resourceRecords = new SdkInternalList<ResourceRecord>(resourceRecords);
    }

    public ResourceRecordSet withResourceRecords(ResourceRecord ... resourceRecords) {
        if (this.resourceRecords == null) {
            this.setResourceRecords(new SdkInternalList<ResourceRecord>(resourceRecords.length));
        }
        for (ResourceRecord ele : resourceRecords) {
            this.resourceRecords.add(ele);
        }
        return this;
    }

    public ResourceRecordSet withResourceRecords(Collection<ResourceRecord> resourceRecords) {
        this.setResourceRecords(resourceRecords);
        return this;
    }

    public void setAliasTarget(AliasTarget aliasTarget) {
        this.aliasTarget = aliasTarget;
    }

    public AliasTarget getAliasTarget() {
        return this.aliasTarget;
    }

    public ResourceRecordSet withAliasTarget(AliasTarget aliasTarget) {
        this.setAliasTarget(aliasTarget);
        return this;
    }

    public void setHealthCheckId(String healthCheckId) {
        this.healthCheckId = healthCheckId;
    }

    public String getHealthCheckId() {
        return this.healthCheckId;
    }

    public ResourceRecordSet withHealthCheckId(String healthCheckId) {
        this.setHealthCheckId(healthCheckId);
        return this;
    }

    public void setTrafficPolicyInstanceId(String trafficPolicyInstanceId) {
        this.trafficPolicyInstanceId = trafficPolicyInstanceId;
    }

    public String getTrafficPolicyInstanceId() {
        return this.trafficPolicyInstanceId;
    }

    public ResourceRecordSet withTrafficPolicyInstanceId(String trafficPolicyInstanceId) {
        this.setTrafficPolicyInstanceId(trafficPolicyInstanceId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSetIdentifier() != null) {
            sb.append("SetIdentifier: ").append(this.getSetIdentifier()).append(",");
        }
        if (this.getWeight() != null) {
            sb.append("Weight: ").append(this.getWeight()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getGeoLocation() != null) {
            sb.append("GeoLocation: ").append(this.getGeoLocation()).append(",");
        }
        if (this.getFailover() != null) {
            sb.append("Failover: ").append(this.getFailover()).append(",");
        }
        if (this.getTTL() != null) {
            sb.append("TTL: ").append(this.getTTL()).append(",");
        }
        if (this.getResourceRecords() != null) {
            sb.append("ResourceRecords: ").append(this.getResourceRecords()).append(",");
        }
        if (this.getAliasTarget() != null) {
            sb.append("AliasTarget: ").append(this.getAliasTarget()).append(",");
        }
        if (this.getHealthCheckId() != null) {
            sb.append("HealthCheckId: ").append(this.getHealthCheckId()).append(",");
        }
        if (this.getTrafficPolicyInstanceId() != null) {
            sb.append("TrafficPolicyInstanceId: ").append(this.getTrafficPolicyInstanceId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRecordSet)) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSetIdentifier() == null ^ this.getSetIdentifier() == null) {
            return false;
        }
        if (other.getSetIdentifier() != null && !other.getSetIdentifier().equals(this.getSetIdentifier())) {
            return false;
        }
        if (other.getWeight() == null ^ this.getWeight() == null) {
            return false;
        }
        if (other.getWeight() != null && !other.getWeight().equals(this.getWeight())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getGeoLocation() == null ^ this.getGeoLocation() == null) {
            return false;
        }
        if (other.getGeoLocation() != null && !other.getGeoLocation().equals(this.getGeoLocation())) {
            return false;
        }
        if (other.getFailover() == null ^ this.getFailover() == null) {
            return false;
        }
        if (other.getFailover() != null && !other.getFailover().equals(this.getFailover())) {
            return false;
        }
        if (other.getTTL() == null ^ this.getTTL() == null) {
            return false;
        }
        if (other.getTTL() != null && !other.getTTL().equals(this.getTTL())) {
            return false;
        }
        if (other.getResourceRecords() == null ^ this.getResourceRecords() == null) {
            return false;
        }
        if (other.getResourceRecords() != null && !other.getResourceRecords().equals(this.getResourceRecords())) {
            return false;
        }
        if (other.getAliasTarget() == null ^ this.getAliasTarget() == null) {
            return false;
        }
        if (other.getAliasTarget() != null && !other.getAliasTarget().equals(this.getAliasTarget())) {
            return false;
        }
        if (other.getHealthCheckId() == null ^ this.getHealthCheckId() == null) {
            return false;
        }
        if (other.getHealthCheckId() != null && !other.getHealthCheckId().equals(this.getHealthCheckId())) {
            return false;
        }
        if (other.getTrafficPolicyInstanceId() == null ^ this.getTrafficPolicyInstanceId() == null) {
            return false;
        }
        return other.getTrafficPolicyInstanceId() == null || other.getTrafficPolicyInstanceId().equals(this.getTrafficPolicyInstanceId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSetIdentifier() == null ? 0 : this.getSetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getWeight() == null ? 0 : this.getWeight().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getGeoLocation() == null ? 0 : this.getGeoLocation().hashCode());
        hashCode = 31 * hashCode + (this.getFailover() == null ? 0 : this.getFailover().hashCode());
        hashCode = 31 * hashCode + (this.getTTL() == null ? 0 : this.getTTL().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRecords() == null ? 0 : this.getResourceRecords().hashCode());
        hashCode = 31 * hashCode + (this.getAliasTarget() == null ? 0 : this.getAliasTarget().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckId() == null ? 0 : this.getHealthCheckId().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficPolicyInstanceId() == null ? 0 : this.getTrafficPolicyInstanceId().hashCode());
        return hashCode;
    }

    public ResourceRecordSet clone() {
        try {
            return (ResourceRecordSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

