/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.SnapshotAttributeName;
import com.amazonaws.services.ec2.model.transform.ResetSnapshotAttributeRequestMarshaller;
import java.io.Serializable;

public class ResetSnapshotAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ResetSnapshotAttributeRequest> {
    private String attribute;
    private String snapshotId;

    public ResetSnapshotAttributeRequest() {
    }

    public ResetSnapshotAttributeRequest(String snapshotId, String attribute) {
        this.setSnapshotId(snapshotId);
        this.setAttribute(attribute);
    }

    public ResetSnapshotAttributeRequest(String snapshotId, SnapshotAttributeName attribute) {
        this.setSnapshotId(snapshotId);
        this.setAttribute(attribute.toString());
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ResetSnapshotAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setAttribute(SnapshotAttributeName attribute) {
        this.attribute = attribute.toString();
    }

    public ResetSnapshotAttributeRequest withAttribute(SnapshotAttributeName attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public ResetSnapshotAttributeRequest withSnapshotId(String snapshotId) {
        this.setSnapshotId(snapshotId);
        return this;
    }

    @Override
    public Request<ResetSnapshotAttributeRequest> getDryRunRequest() {
        Request<ResetSnapshotAttributeRequest> request = new ResetSnapshotAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getSnapshotId() != null) {
            sb.append("SnapshotId: ").append(this.getSnapshotId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetSnapshotAttributeRequest)) {
            return false;
        }
        ResetSnapshotAttributeRequest other = (ResetSnapshotAttributeRequest)obj;
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        return other.getSnapshotId() == null || other.getSnapshotId().equals(this.getSnapshotId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        return hashCode;
    }

    @Override
    public ResetSnapshotAttributeRequest clone() {
        return (ResetSnapshotAttributeRequest)super.clone();
    }
}

