/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.NextStateTransition;
import com.amazonaws.services.stepfunctions.builder.states.PathContainer;
import com.amazonaws.services.stepfunctions.builder.states.ResultPathBuilder;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import com.amazonaws.thirdparty.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Catcher {
    @JsonProperty(value="ErrorEquals")
    private final List<String> errorEquals;
    @JsonUnwrapped
    private final PathContainer pathContainer;
    @JsonUnwrapped
    private final Transition transition;

    private Catcher(Builder builder) {
        this.errorEquals = new ArrayList<String>(builder.errorEquals);
        this.pathContainer = builder.pathContainer.build();
        this.transition = (Transition)builder.transition.build();
    }

    public List<String> getErrorEquals() {
        return this.errorEquals;
    }

    @JsonIgnore
    public String getResultPath() {
        return this.pathContainer.getResultPath();
    }

    public Transition getTransition() {
        return this.transition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Buildable<Catcher>,
    ResultPathBuilder<Builder> {
        @JsonProperty(value="ErrorEquals")
        private List<String> errorEquals = new ArrayList<String>();
        private final PathContainer.Builder pathContainer = PathContainer.builder();
        private Transition.Builder transition = Transition.NULL_BUILDER;

        private Builder() {
        }

        public Builder errorEquals(String ... errorEquals) {
            Collections.addAll(this.errorEquals, errorEquals);
            return this;
        }

        public Builder catchAll() {
            this.errorEquals.clear();
            this.errorEquals("States.ALL");
            return this;
        }

        @Override
        public Builder resultPath(String resultPath) {
            this.pathContainer.resultPath(resultPath);
            return this;
        }

        @JsonProperty(value="Next")
        private Builder nextStateName(String nextStateName) {
            return this.transition(NextStateTransition.builder().nextStateName(nextStateName));
        }

        public Builder transition(NextStateTransition.Builder transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public Catcher build() {
            return new Catcher(this);
        }
    }
}

