/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    @Override
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        SdkInternalList describeVolumesRequestFiltersList;
        if (describeVolumesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVolumesRequest> request = new DefaultRequest<DescribeVolumesRequest>(describeVolumesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVolumes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVolumesRequestVolumeIdsList = (SdkInternalList)describeVolumesRequest.getVolumeIds();
        if (!describeVolumesRequestVolumeIdsList.isEmpty() || !describeVolumesRequestVolumeIdsList.isAutoConstruct()) {
            int volumeIdsListIndex = 1;
            for (String describeVolumesRequestVolumeIdsListValue : describeVolumesRequestVolumeIdsList) {
                if (describeVolumesRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString(describeVolumesRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        if (!(describeVolumesRequestFiltersList = (SdkInternalList)describeVolumesRequest.getFilters()).isEmpty() || !describeVolumesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVolumesRequestFiltersListValue : describeVolumesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVolumesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeVolumesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVolumesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVolumesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVolumesRequest.getNextToken()));
        }
        if (describeVolumesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVolumesRequest.getMaxResults()));
        }
        return request;
    }
}

