/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeContainerInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> containerInstances;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public DescribeContainerInstancesRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new SdkInternalList();
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        this.containerInstances = new SdkInternalList<String>(containerInstances);
    }

    public DescribeContainerInstancesRequest withContainerInstances(String ... containerInstances) {
        if (this.containerInstances == null) {
            this.setContainerInstances(new SdkInternalList<String>(containerInstances.length));
        }
        for (String ele : containerInstances) {
            this.containerInstances.add(ele);
        }
        return this;
    }

    public DescribeContainerInstancesRequest withContainerInstances(Collection<String> containerInstances) {
        this.setContainerInstances(containerInstances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: ").append(this.getContainerInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesRequest)) {
            return false;
        }
        DescribeContainerInstancesRequest other = (DescribeContainerInstancesRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        return other.getContainerInstances() == null || other.getContainerInstances().equals(this.getContainerInstances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        return hashCode;
    }

    @Override
    public DescribeContainerInstancesRequest clone() {
        return (DescribeContainerInstancesRequest)super.clone();
    }
}

