/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticsearch.model.AdditionalLimit;
import com.amazonaws.services.elasticsearch.model.InstanceLimits;
import com.amazonaws.services.elasticsearch.model.StorageType;
import com.amazonaws.services.elasticsearch.model.transform.LimitsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Limits
implements Serializable,
Cloneable,
StructuredPojo {
    private List<StorageType> storageTypes;
    private InstanceLimits instanceLimits;
    private List<AdditionalLimit> additionalLimits;

    public List<StorageType> getStorageTypes() {
        return this.storageTypes;
    }

    public void setStorageTypes(Collection<StorageType> storageTypes) {
        if (storageTypes == null) {
            this.storageTypes = null;
            return;
        }
        this.storageTypes = new ArrayList<StorageType>(storageTypes);
    }

    public Limits withStorageTypes(StorageType ... storageTypes) {
        if (this.storageTypes == null) {
            this.setStorageTypes(new ArrayList<StorageType>(storageTypes.length));
        }
        for (StorageType ele : storageTypes) {
            this.storageTypes.add(ele);
        }
        return this;
    }

    public Limits withStorageTypes(Collection<StorageType> storageTypes) {
        this.setStorageTypes(storageTypes);
        return this;
    }

    public void setInstanceLimits(InstanceLimits instanceLimits) {
        this.instanceLimits = instanceLimits;
    }

    public InstanceLimits getInstanceLimits() {
        return this.instanceLimits;
    }

    public Limits withInstanceLimits(InstanceLimits instanceLimits) {
        this.setInstanceLimits(instanceLimits);
        return this;
    }

    public List<AdditionalLimit> getAdditionalLimits() {
        return this.additionalLimits;
    }

    public void setAdditionalLimits(Collection<AdditionalLimit> additionalLimits) {
        if (additionalLimits == null) {
            this.additionalLimits = null;
            return;
        }
        this.additionalLimits = new ArrayList<AdditionalLimit>(additionalLimits);
    }

    public Limits withAdditionalLimits(AdditionalLimit ... additionalLimits) {
        if (this.additionalLimits == null) {
            this.setAdditionalLimits(new ArrayList<AdditionalLimit>(additionalLimits.length));
        }
        for (AdditionalLimit ele : additionalLimits) {
            this.additionalLimits.add(ele);
        }
        return this;
    }

    public Limits withAdditionalLimits(Collection<AdditionalLimit> additionalLimits) {
        this.setAdditionalLimits(additionalLimits);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStorageTypes() != null) {
            sb.append("StorageTypes: ").append(this.getStorageTypes()).append(",");
        }
        if (this.getInstanceLimits() != null) {
            sb.append("InstanceLimits: ").append(this.getInstanceLimits()).append(",");
        }
        if (this.getAdditionalLimits() != null) {
            sb.append("AdditionalLimits: ").append(this.getAdditionalLimits());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limits)) {
            return false;
        }
        Limits other = (Limits)obj;
        if (other.getStorageTypes() == null ^ this.getStorageTypes() == null) {
            return false;
        }
        if (other.getStorageTypes() != null && !other.getStorageTypes().equals(this.getStorageTypes())) {
            return false;
        }
        if (other.getInstanceLimits() == null ^ this.getInstanceLimits() == null) {
            return false;
        }
        if (other.getInstanceLimits() != null && !other.getInstanceLimits().equals(this.getInstanceLimits())) {
            return false;
        }
        if (other.getAdditionalLimits() == null ^ this.getAdditionalLimits() == null) {
            return false;
        }
        return other.getAdditionalLimits() == null || other.getAdditionalLimits().equals(this.getAdditionalLimits());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStorageTypes() == null ? 0 : this.getStorageTypes().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceLimits() == null ? 0 : this.getInstanceLimits().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalLimits() == null ? 0 : this.getAdditionalLimits().hashCode());
        return hashCode;
    }

    public Limits clone() {
        try {
            return (Limits)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LimitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

