/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.apache.http.impl.execchain;

import com.amazonaws.thirdparty.apache.http.Header;
import com.amazonaws.thirdparty.apache.http.HttpException;
import com.amazonaws.thirdparty.apache.http.annotation.Immutable;
import com.amazonaws.thirdparty.apache.http.client.ServiceUnavailableRetryStrategy;
import com.amazonaws.thirdparty.apache.http.client.methods.CloseableHttpResponse;
import com.amazonaws.thirdparty.apache.http.client.methods.HttpExecutionAware;
import com.amazonaws.thirdparty.apache.http.client.methods.HttpRequestWrapper;
import com.amazonaws.thirdparty.apache.http.client.protocol.HttpClientContext;
import com.amazonaws.thirdparty.apache.http.conn.routing.HttpRoute;
import com.amazonaws.thirdparty.apache.http.impl.execchain.ClientExecChain;
import com.amazonaws.thirdparty.apache.http.util.Args;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import java.io.IOException;
import java.io.InterruptedIOException;

@Immutable
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

