/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig;
import com.amazonaws.services.elasticbeanstalk.model.MaxAgeRule;
import com.amazonaws.services.elasticbeanstalk.model.MaxCountRule;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateApplicationResourceLifecycleRequestMarshaller
implements Marshaller<Request<UpdateApplicationResourceLifecycleRequest>, UpdateApplicationResourceLifecycleRequest> {
    @Override
    public Request<UpdateApplicationResourceLifecycleRequest> marshall(UpdateApplicationResourceLifecycleRequest updateApplicationResourceLifecycleRequest) {
        ApplicationResourceLifecycleConfig resourceLifecycleConfig;
        if (updateApplicationResourceLifecycleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateApplicationResourceLifecycleRequest> request = new DefaultRequest<UpdateApplicationResourceLifecycleRequest>(updateApplicationResourceLifecycleRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "UpdateApplicationResourceLifecycle");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateApplicationResourceLifecycleRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(updateApplicationResourceLifecycleRequest.getApplicationName()));
        }
        if ((resourceLifecycleConfig = updateApplicationResourceLifecycleRequest.getResourceLifecycleConfig()) != null) {
            ApplicationVersionLifecycleConfig versionLifecycleConfig;
            if (resourceLifecycleConfig.getServiceRole() != null) {
                request.addParameter("ResourceLifecycleConfig.ServiceRole", StringUtils.fromString(resourceLifecycleConfig.getServiceRole()));
            }
            if ((versionLifecycleConfig = resourceLifecycleConfig.getVersionLifecycleConfig()) != null) {
                MaxAgeRule maxAgeRule;
                MaxCountRule maxCountRule = versionLifecycleConfig.getMaxCountRule();
                if (maxCountRule != null) {
                    if (maxCountRule.getEnabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.Enabled", StringUtils.fromBoolean(maxCountRule.getEnabled()));
                    }
                    if (maxCountRule.getMaxCount() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.MaxCount", StringUtils.fromInteger(maxCountRule.getMaxCount()));
                    }
                    if (maxCountRule.getDeleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.DeleteSourceFromS3", StringUtils.fromBoolean(maxCountRule.getDeleteSourceFromS3()));
                    }
                }
                if ((maxAgeRule = versionLifecycleConfig.getMaxAgeRule()) != null) {
                    if (maxAgeRule.getEnabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.Enabled", StringUtils.fromBoolean(maxAgeRule.getEnabled()));
                    }
                    if (maxAgeRule.getMaxAgeInDays() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.MaxAgeInDays", StringUtils.fromInteger(maxAgeRule.getMaxAgeInDays()));
                    }
                    if (maxAgeRule.getDeleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.DeleteSourceFromS3", StringUtils.fromBoolean(maxAgeRule.getDeleteSourceFromS3()));
                    }
                }
            }
        }
        return request;
    }
}

