/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.internal.DateModule;
import com.amazonaws.services.stepfunctions.builder.internal.validation.StateMachineValidator;
import com.amazonaws.services.stepfunctions.builder.states.State;
import com.amazonaws.thirdparty.jackson.annotation.JsonInclude;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import com.amazonaws.thirdparty.jackson.core.JsonProcessingException;
import com.amazonaws.thirdparty.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class StateMachine {
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule(DateModule.INSTANCE);
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="StartAt")
    private final String startAt;
    @JsonProperty(value="TimeoutSeconds")
    private final Integer timeoutSeconds;
    @JsonProperty(value="States")
    private final Map<String, State> states;

    private StateMachine(Builder builder) {
        this.comment = builder.comment;
        this.startAt = builder.startAt;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.states = Buildable.Utils.build(builder.states);
    }

    public String getComment() {
        return this.comment;
    }

    public String getStartAt() {
        return this.startAt;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Map<String, State> getStates() {
        return this.states;
    }

    public String toJson() {
        try {
            return MAPPER.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new SdkClientException("Could not serialize state machine.", e);
        }
    }

    public String toPrettyJson() {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new SdkClientException("Could not serialize state machine.", e);
        }
    }

    public static Builder fromJson(String json) {
        try {
            return MAPPER.readValue(json, Builder.class);
        }
        catch (IOException e) {
            throw new SdkClientException(String.format("Could not deserialize state machine.\n%s", json), e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="StartAt")
        private String startAt;
        @JsonProperty(value="TimeoutSeconds")
        private Integer timeoutSeconds;
        @JsonProperty(value="States")
        private final Map<String, State.Builder> states = new LinkedHashMap<String, State.Builder>();

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder state(String stateName, State.Builder stateBuilder) {
            this.states.put(stateName, stateBuilder);
            return this;
        }

        public StateMachine build() {
            return new StateMachineValidator(new StateMachine(this)).validate();
        }
    }
}

