/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.transform.VaultNotificationConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VaultNotificationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String sNSTopic;
    private List<String> events;

    public VaultNotificationConfig() {
    }

    public VaultNotificationConfig(String sNSTopic, List<String> events) {
        this.setSNSTopic(sNSTopic);
        this.setEvents(events);
    }

    public void setSNSTopic(String sNSTopic) {
        this.sNSTopic = sNSTopic;
    }

    public String getSNSTopic() {
        return this.sNSTopic;
    }

    public VaultNotificationConfig withSNSTopic(String sNSTopic) {
        this.setSNSTopic(sNSTopic);
        return this;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<String> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<String>(events);
    }

    public VaultNotificationConfig withEvents(String ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<String>(events.length));
        }
        for (String ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public VaultNotificationConfig withEvents(Collection<String> events) {
        this.setEvents(events);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSNSTopic() != null) {
            sb.append("SNSTopic: ").append(this.getSNSTopic()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaultNotificationConfig)) {
            return false;
        }
        VaultNotificationConfig other = (VaultNotificationConfig)obj;
        if (other.getSNSTopic() == null ^ this.getSNSTopic() == null) {
            return false;
        }
        if (other.getSNSTopic() != null && !other.getSNSTopic().equals(this.getSNSTopic())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSNSTopic() == null ? 0 : this.getSNSTopic().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public VaultNotificationConfig clone() {
        try {
            return (VaultNotificationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VaultNotificationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

